## 周边车辆SDK

周边车辆sdk是针对于出行场景（周边车辆）开发的SDK。该产品能够对召回的的周边车辆进行分类型展示，并提供车辆平滑移动的功能。此sdk需要配合地图sdk使用。

### 一、密钥申请

与腾讯地图key一致，如已申请，可直接使用。如未申请，可在[官网申请](https://lbs.qq.com/android_v1/guide-project-setup.html)。如果在官网开启签名校验的方式，周边车辆sdk需要配合使用setWebServiceKey方法。

```java
	// 开启签名校验
        previewMapManager.setWebServiceKey(“sn key”, true)
```

<p align="left">
  <img width="550" height="320" src="https://github.com/tentcentmap-mobility/mapmobilitydemo-passenger-Android/blob/master/app/src/main/assets/img/wb_api.png">
</p>

### 二、配置文件

添加权限。需要主要的是在6.0+系统需要动态获取权限。

```java
    <!-- 通过网络得到粗略位置 -->
    <uses-permission android:name="android.permission.ACCESS_COARSE_LOCATION" />
    <!--获取 device id 辨别设备-->
    <uses-permission android:name="android.permission.READ_PHONE_STATE" />
    <!--需要外部存储写权限用于保存地图缓存-->
    <uses-permission android:name="android.permission.WRITE_EXTERNAL_STORAGE" />
```

需要在AndroidMainfest文件中的<application/>节点下添加key。

```java
        <meta-data
            android:name="com.tencent.map.carpreview.api_key"
            android:value="用户申请key，与地图key一致"
            />
```

在build gradle中依赖如下。

```java
    // 腾讯地图sdk
    implementation 'com.tencent.map:tencent-map-vector-sdk:4.3.3.5'
    // 基础库
    implementation 'com.tencent.map:tencent-map-nav-surport:1.0.2.4'
    // 目前只支持aar方式，需配合地图版本4.3.3.5
    implementation files('libs/tencentcarpreview_v1.2.0.aar')
```

### 三、初始化

周边车辆sdk提供了TencentCarsMap来进行周边车辆展示。用户可通过mTencentCarsMap.getTencentMap()来获取内部的地图tencentMap。TencentCarsMap使用如下，其中map_top_ratio属性：屏幕中心点y的比例，距离屏幕上边距离:屏幕高，可隐藏默认大头针 marker。

```java
    <com.tencent.map.carpreview.ui.TencentCarsMap
        android:id="@+id/cars_map"
        android:layout_width="match_parent"
        android:layout_height="match_parent"
        app:map_top_ratio="0.5" />
```

这是周边车辆sdk初始化的方法。注意地图的生命周期方法别忘了调用。

```java
	TencentCarsMap mTencentCarsMap = findViewById(R.id.cars_map);
        PreviewMapManager.init(this);
        PreviewMapManager previewMapManager = new PreviewMapManager();
```
关联地图 map OnCameraChangeListener，同步给周边车辆SDK。

```java
    private TencentMap.OnCameraChangeListener cameraChangeListener
            = new TencentMap.OnCameraChangeListener() {
        @Override
        public void onCameraChange(CameraPosition cameraPosition) {

        }

        @Override
        public void onCameraChangeFinished(CameraPosition cameraPosition) {
            if (previewMapManager != null)
                previewMapManager.onCameraChangeFinish(cameraPosition);
        }
    };

    // 添加地图 map 拖动监听
    mTencentCarsMap.getTencentMap().setOnCameraChangeListener(cameraChangeListener);

```

请求数据。如果sdk已关联 map onCameraChanged 的监听，当地图移动会自动请求数据。

```java
        // 移动地图中心点至latlng，随后刷新
	previewMapManager.setCurrentLatLng(lastLanlng);
	// 直接刷新
        previewMapManager.getNearbyCars(lastLanlng);
```

### 四、参数配置

这是TencentCarsMap的方法列表，使用方法如下。

```java
        mTencentCarsMap.hidePoiMaker();// 不使用默认大头针图标
```

具体方法列表见下。

|   方法名   |   含义   |
| ---- | ---- |
|   showPoiMaker()   |   显示默认大头针图标   |
|   hidePoiMaker()  |   隐藏默认大头针图标   |
|   clearCarsMarkers()  |   清除车辆的Marker   |

这是PreviewMapManager提供的方法列表，部分代码使用如下。

```java
        previewMapManager.setMock(true);// 模拟数据
        previewMapManager.setRadius(3000);// 召回半径3000米
        previewMapManager.setCity(440100);// 广州
	ArrayList types = new ArrayList();
        types.add("1");
        types.add("2");
        previewMapManager.setCarsType(types);// 请求“1”，“2”两种类型的车辆数据
        previewMapManager.attachCarsMap(mTencentCarsMap);// 关联地图

        /** HashMap<String, Integer> typeResMap = new HashMap<>();
        typeResMap.put("1", R.mipmap.car1);// 只需初始化的时候调用一次，一次需设置全部图片资源
        typeResMap.put("2", R.mipmap.car2);
        try {
            previewMapManager.setCarsTypeResMap(typeResMap);// 添加不同类型对应的图片资源
        } catch (Exception e) {
            e.printStackTrace();
        } */

	// 可以控制 carType 对应 Res 是否旋转
        // 可替代 PreviewMapManager#setCarsTypeResMap 方法
        HashMap<String, CarTypeConfig> typeResMap = new HashMap<>();
        CarTypeConfig carTypeConfig1 = new CarTypeConfig();
        carTypeConfig1.setRes(R.mipmap.car1);
        carTypeConfig1.setWillRotate(false);

        CarTypeConfig carTypeConfig2 = new CarTypeConfig();
        carTypeConfig2.setRes(R.mipmap.car2);
        carTypeConfig2.setWillRotate(false);

        typeResMap.put("1", carTypeConfig1);
        typeResMap.put("2", carTypeConfig2);

        try {
            previewMapManager.setCarTypeConfigMap(typeResMap);
        } catch (Exception e) {
            e.printStackTrace();
        }

```

具体方法作用见下表，也可参考接口文档。

|   方法名   |   含义   |
| ---- | ---- |
|   setKey(String key)   |   设置开放平台的Key（推荐在Mainfest中配置）   |
|   setCarsCount(int carsCount)   |   设置请求附近车数量，默认10   |
|   setRadius(int radius)    |   请求周边车辆范围，默认5000，单位米   |
|   setCity(int city)   |   设置城市编码，6位，如:110000(北京)   |
|   attachCarsMap(TencentCarsMap tencentMap)  |    绑定地图View   |
|   setCarsTypeResMap(HashMap<String, Integer> typeResMap)   |   设置车辆类型与车辆icon对应关系，icon是Res文件里的drawable id   |
|   setCarTypeConfigMap(HashMap<String, CarTypeConfig> carTypeConfigMap)   |   设置车辆类型与车辆配置的对应关系，可替代setCarsTypeResMap   |
|   setCurrentLatLng(LatLng latLng)   |   移动地图中心点至latlng，并刷新数据   |
|   setCarsType(List<String> types)   |   设置车辆类型，需与setCarsTypeResMap对应。如1:出租车，2:新能源，3:舒适型，4:豪华型，5:商务型，6:经济型   |
|   getNearbyCars(LatLng latLng)   |   刷新数据   |
|   setMock(boolean mock)   |   使用模拟数据，默认false   |
|   setWebServiceKey(String key, boolean isWebServiceKey)   |   设置签名校验方式，false:白名单，true:WebServiceAPI Key签名校验，默认false   |
|   startRefresh(int refreshTime)   |   数据刷新，并定时。如果refreshTime==0则不刷新，单位秒   |
|   stopRefresh()   |   停止刷新   |
|   isOpenLog(boolean isOpenLog)   |   debug模式下输出log，默认false   |
|   isNearCarShow(boolean isNearCarShow)   |   周边车辆展示开关，默认true   |
|   setTimeDelta(int timeDelta)   |   设置司机最后更新状态的时间间隔(超过此时间段未上传点的司机，则不召回)，默认60秒   |
|   registerNearbyCarsListener(INearbyListener callBack)   |   注册数据接口回调callBack   |
|   unregisterNearbyCarsListener(INearbyListener callBack)   |   取消回调callBack   |

### 五、混淆

在proguard-rules.pro中添加混淆代码。

```java
    # 地图
    -keep class com.tencent.tencentmap.**{*;}
    -keep class com.tencent.map.**{*;}
    -keep class com.tencent.beacontmap.**{*;}
    -keep class com.tencent.tencentmap.mapsdk.maps.BaseMapView{*;}
    -keep class navsns.**{*;}
    -dontwarn com.qq.**
    -dontwarn com.tencent.beacon.**
    # 周边车辆
    -keep class com.tencent.map.carpreview.**{*;}
```
