## 司乘同显SDK接⼊⽂档（安卓）

### 概述

司乘同显SDK是在⽹约⻋接驾送驾场景中，帮助司机和乘客两端实时了解⾏程信息，可以同步展示司机
端的路线、路况、剩余⾥程和剩余时间以及双⽅的实时位置和⾏驶轨迹。

乘客端使⽤司乘同显SDK时，需要依赖地图SDK，通过地图SDK中进⾏路线绘制、添加覆盖物等功能。
使⽤司乘同显SDK时需配置订单ID、司机ID和乘客ID来建⽴三者的关联关系。另外，订单有三个属性，
分别是订单ID，订单类型和订单状态，订单类型包括快⻋和顺⻛⻋，订单状态包括未派单、已派单、计
费中。

⽤户可使⽤Deme查看司乘SDK的使⽤效果。准备两个⼿机，⼀个打开司机端，另⼀个打开乘客端。测
试时，司机端已开启同步功能并且已经进⼊导航界⾯，乘客端点击“启动同步”按钮，可看到司机端当前
路线和⼩⻋的平滑移动效果。

### 准备⼯作

#### 申请开发密钥

司乘SDK使⽤前需要先配置APIKey进⾏鉴权，具体可联系对应的商务同学来开通。

#### ⼯程配置

##### ⼀、配置地图SDK（必须）

司乘同显SDK（司机端&乘客端）需要依赖3D地图SDK，可在官⽹进⾏3D地图SDK的下载和⼯程配置
（地图⼯程配置指引：https://lbs.qq.com/android_v1/index.html 地图key申请成功后，可在
gradle⽂件中引⽤，如：

```java
    implementation 'com.tencent.map:tencent-map-vector-sdk:4.3.3.5'
```

并在AndroidMainfest⽂件中，配置key，如：

```java
    <meta-data
        android:name="TencentMapSDK"
        android:value="官⽹申请的地图key" />
```

##### ⼆、配置导航SDK（必须）

司乘同显SDK司机端需配合导航SDK使⽤，导航权限可联系对应的商务同学来开通。开通权限后，可在
gradle⽂件中引⽤，如：

```java
    // 需与地图SDKv4.3.3.5版本搭配使⽤
    implementation 'com.tencent.map:tencent-map-nav-sdk:5.1.9.11'
```

需要注意的是，导航SDK需要依赖基础库SDK、检索SDK，具体如下：

```java
    // 基础工具库
    implementation 'com.tencent.map:tencent-map-nav-surport:1.0.2.4'
```

##### 三、司乘SDK

开通权限后，需在AndroidMainfest⽂件中配置key，如：

```java
    <meta-data
        android:name="com.tencent.map.ls.api_key"
        android:value="申请的司乘key" />
```

##### 四、配置定位SDK

定位SDK的使⽤可以参考官⽹：https://lbs.qq.com/geo/index.html ，注：具体配置可参考gitHub demo

### 快速接⼊

#### 司机端

初始化配置，包括司机id和设备id，代码如下：

```java
    /**
     * 导航SDK 管理类
     *
     * <p>推荐使用单例模式
     */
    TencentCarNaviManager naviManager = new TencentCarNaviManager(getApplicationContext());
    /**
     * 司乘地图
     */
    carNaviView = findViewById(R.id.navi_car_view);// 导航INaviView
    /**
     * 司乘SDK 管理类
     */
    TSLDExtendManager lsManager = TSLDExtendManager.getInstance();

    /**
     * 司乘SDK 关联导航SDK和导航地图
     *
     * <p>帮助用户处理导航过程中的定位点、路线的上报逻辑
     * 关联地图可为用户设置途经点图标
     */
    lsManager.setNaviManager(naviManager);
    lsManager.setCarNaviView(carNaviView);

    /**
     * 司乘SDK 的初始化
     *
     * 配置信息类{@code TLSConfigPreference}可参考接口文档
     */
    lsManager.init(getApplicationContext(), TLSConfigPreference.create()
         .setDeviceId(DeviceUtils.getImei(getApplicationContext())) // 设备id
         .setAccountId(driverId)); // 司机id
```

开启司乘同显司机端，代码如下：

```java
    lsManager.start(); // 开启司乘
```

设置起终点和途经点，并开始算路，**司乘SDK提供的顺风车与拼车算路方法区别见下注释**。因为司乘同显司机端manager会持有导航manager和导航
map，所以⽤户能够通过司乘manager直接对导航sdk进⾏操作。算路代码如下：

```java
    /**
     * 导航的起点
     * 按场景设置PoiId
     */
    NaviPoi from = new NaviPoi(40.041032,116.27245);
    /**
     * 导航的终点
     * 按场景设置PoiId
     */
    NaviPoi to = new NaviPoi(39.868699,116.32198);
    /**
     * 导航的途经点，按场景设置PoiId
     * 顺⻛⻋和拼车需要，快⻋可不添加
     */
    ArrayList<TLSDWayPointInfo> ws = new ArrayList<>();

    TLSDWayPointInfo w1 = new TLSDWayPointInfo();
    w1.setpOrderId("test_passenger_order_000011"); // 乘客1订单id
    w1.setWayPointType(TLSBWayPointType.TLSDWayPointTypeGetIn); // 乘客1的上⻋点
    w1.setLat(39.940080); // 上车点的纬度
    w1.setLng(116.355257); // 上车点的经度

    TLSDWayPointInfo w2 = new TLSDWayPointInfo();
    w2.setpOrderId("test_passenger_order_000011"); // 乘客1订单id
    w2.setWayPointType(TLSBWayPointType.TLSDWayPointTypeGetOff); // 乘客1的下⻋点
    w2.setLat(39.923890); // 下车点的纬度
    w2.setLng(116.344700); // 下车点的经度

    ws.add(w1);
    ws.add(w2);

    /**
     * 开始算路，这是司乘SDK提供的算路接口
     * 与导航SDK的算路接口无区别，只是司乘为用户封装了部分处理逻辑
     *
     * <p>在拼车场景中，因为没有导航终点，所以需要使用{@link TSLDExtendManager#searchCarRoutes
     * (NaviPoi, ArrayList, CarRouteSearchOptions, ISearchCallBack)}方法。而在顺风车场景下，存在导航终点，所以需要
     * 使用重载方法{@link TSLDExtendManager#searchCarRoutes
     * (NaviPoi, NaviPoi, ArrayList, CarRouteSearchOptions, ISearchCallBack)}
     *
     * <p>下面以顺风车场景的最优算路接口，五个参数的方法为例。
     */
    lsManager.searchCarRoutes(from, to, ws, CarRouteSearchOptions.create()
        , new DriDataListener.ISearchCallBack() {
            @Override
            public void onParamsInvalid(int errCode, String errMsg) {
            ToastUtils.INSTANCE().Toast("参数不合法!!");
            }

            @Override
            public void onRouteSearchFailure(int i, String s) {
            ToastUtils.INSTANCE().Toast("算路失败!!");
            }

            @Override
            public void onRouteSearchSuccess(ArrayList<RouteData> arrayList) {
            ToastUtils.INSTANCE().Toast("算路成功");
            }
    });
```

在算路之前，用户可根据需要是否使用**最优送驾顺序接口，顺风车场景与拼车场景区别见注释**，代码示例：

```java
    /**
     * 在拼车场景中，因为没有导航终点，所以需要使用{@link TSLDExtendManager#requestBestSortedWayPoints
     * (NaviPoi, ArrayList, ISortedWayPointsCallBack)}方法。而在顺风车场景下，存在导航终点，所以需要
     * 使用重载方法{@link TSLDExtendManager#requestBestSortedWayPoints
     * (NaviPoi, NaviPoi, ArrayList, ISortedWayPointsCallBack)}
     *
     * <p>下面以顺风车场景的最优算路接口，四个参数的方法为例。
     */
    lsManager.requestBestSortedWayPoints(from, to, sorts, new DriDataListener.ISortedWayPointsCallBack() {
        @Override
        public void onSortedWaysSuc(ArrayList<TLSDWayPointInfo> sortedWays) {
            /**
	     * {@code sortedWays}是排序好的途经点
	     * 用户可以使用{@code sortedWays}直接开启算路
	     *
	     * @see TLSDWayPointInfo
	     */
        }

        @Override
        public void onSortedWayFail(int errCode, String errMsg) {
            Log.e(LOG_TAG, ">>>errCode : " + errCode + ", errMsg : " + errMsg);
        }
    });
```

上报司机轨迹点信息。司机在⾮导航态，需要⽤户管理定位点的上报⼯作。⽤户可通过定位SDK获取定位信息，
随后将定位点通过司乘SDK的上报接口进行上报。**⽽在导航态，司乘同显sdk会对定位点的上报进⾏管理，⽆需⽤户处理**。非导航态上报代码如下：

```java
    /**
     * {@link TNKLocationManager}是导航SDK内部对于腾讯定位SDK的一个封装
     * {@code TNKLocationManager}为用户实现了对于导航SDK的灌点工作
     * 用户可以通过{@code TNKLocationManager}非常方便的获取定位信息
     *
     * <p>注册监听后，如果定位还未启动，则会启动定位
     */
    loManager = TNKLocationManager.getInstance();
    loManager.setContext(getApplicationContext());
    loManager.addLocationListener(new ITNKLocationCallBack() {
        @Override
        public void requestLocationUpdatesResult(int i) {
        Log.e(LOG_TAG, "start location manager -> result code : " + i);
        }

        @Override
        public void onLocationChanged(TencentLocation tencentLocation, int i, String s) {
            if (lsManager != null && location != null) {
                /**
		 * 上传前，一定要保证订单状态最新
		 */
                lsManager.getTLSBOrder().setOrderStatus(curOrderState)
                     .setOrderId(orderId).setOrderType(curOrderType)
                     .setDrvierStatus(curDrvierStatus)
                     .setCityCode(location.getCityCode());
		/**
		 * 开始上传定位点
		 */
                lsManager.uploadPosition(ConvertHelper.tenPoToTLSDPo(location));
             }
        }

        @Override
        public void onStatusUpdate(String s, int i, String s1) {
            Log.e(LOG_TAG, "location state change !!");
        }
    });
```

上报司机路线信息。在初始化算路和重新进⾏路线规划的时候需要调⽤。同样，在导航态，司乘同显sdk会⾃动处理路线上报⼯作。
非导航态需要用户自己保证路线的正确上报，代码如下：

```java
    /**
     * 订单状态。
     * <ul>
     * <li>初始状态，{@link TLSBOrderStatus#TLSDOrderStatusNone}
     * <li>接驾状态，{{@link TLSBOrderStatus#TLSDOrderStatusPickUp}}
     * <li>送驾状态，{{@link TLSBOrderStatus#TLSDOrderStatusTrip}}
     * </ul>
     *
     * <p>如果是顺风车或拼车订单，开始服务时请切换至TLSDOrderStatusTrip状态
     *
     * <p>订单类型。
     * <ul>
     * <li>快车类型，{@link TLSBOrderType#TLSDOrderTypeNormal}
     * <li>顺风车类型，{{@link TLSBOrderType#TLSDOrderTypeHitchRide}}
     * <li>拼车类型，{{@link TLSBOrderType#TLSBOrderTypeRidesharing}}
     * </ul>
     *
     * <p>司机状态。
     * <ul>
     * <li>司机收车，{@link TLSDDrvierStatus#TLSDDrvierStatusStopped}
     * <li>司机听单中，{@link TLSDDrvierStatus#TLSDDrvierStatusListening}
     * <li>司机服务中，{@link TLSDDrvierStatus#TLSDDrvierStatusServing}
     * </ul>
     */
    lsManager.getTLSBOrder().setOrderStatus(curOrderState) // 当前的订单状态
        .setOrderId(orderId).setOrderType(curOrderType) // 当前的订单类型
        .setDrvierStatus(curDrvierStatus); // 当前的司机状态
    /**
     * 上传路线
     */
    lsManager.uploadRouteWithIndex(curRouteIndex);
```

设置拉取乘客定位点信息。快⻋服务时，可通过如下⽅法设置，**顺⻛⻋和拼车⽬前不⽀持拉取乘客定位信息**。

```java
    lsManager.fetchPassengerPositionsEnabled(true);  // true拉取，false则为停⽌拉取
```

最后是结束司乘同显服务，代码如下：

```java
    lsManager.stop();// 结束司乘
```

**司机端接口回调**，注释如下：

```java
    /**
     * 定位点上传成功
     */
    void onPushPositionSuc();
    /**
     * 定位点上传失败
     */
    void onPushPositionFail(int errCode, String errMsg);
    /**
     * 拉取乘客端轨迹点成功
     */
    void onPullLsInfoSuc(ArrayList<TLSBPosition> los);
    /**
     * 拉取乘客端轨迹点失败
     */
    void onPullLsInfoFail(int errCode, String errMsg);
    /**
     * 上传路线成功
     */
    void onPushRouteSuc();
    /**
     * 上传路线失败
     */
    void onPushRouteFail(int errCode, String errStr);
    /**
     * ⽤户⼿动剔除途经点的回调
     *
     * <p>移除途经点后，⽤户需停⽌导航->重新算路->开启导航
     */
    void onRemoveWayPoint(ArrayList<TLSBWayPoint> wayPoints);
```

#### 乘客端

乘客端与司机端的使用方法很相似，首先需要初始化配置，包括乘客id和设备id，代码如下：

```java
    /**
     * 司乘SDK 乘客端的初始化
     *
     * 配置信息类{@code TLSConfigPreference}可参考接口文档
     */
    tlspManager.init(getApplicationContext(), TLSConfigPreference.create()
         .setAccountId(psgId) // 乘客ID
	 .setDeviceId(deviceId)); // 设备ID
```

开启司乘同显乘客端，代码如下：

```java
    lsManager.start();// 开启司乘
```

最主要的方法是拉取司机信息，如司机的订单信息、路线点串和路线信息，来进行乘客端的展示工作。其中**小车平滑**的详细使用请⻅demo。

```java
    tlspManager.addTLSPassengerListener(new PsgDataListener.ITLSPassengerListener() {
        @Override
        public void onPullLsInfoSuc(TLSDFetchedData fetchedData) {
	     /**
	      * 拉取司机信息成功。
	      * 可进⾏路线绘制，相应起终点（途径点）marker添加，和司机实际轨迹展示。
	      *
	      * <p>小车平滑运动可参考demo
	      */
        }
        @Override
        public void onPullLsInfoFail(int errCode, String errMsg) {
	    /**
	     * 拉取司机信息失败。
	     */
        }

       @Override
       public void onPushPositionSuc() {
	    /**
	     * 上传定位点成功。
	     */
       }

       @Override
       public void onPushPositionFail(int errCode, String errMsg) {
            /**
	     * 上传定位点失败。
	     */
       }
    });
```

乘客也可以上传自己的当前定位信息，来实现在司机端拉取展示乘客位置的功能。目前顺风车和拼车不支持司机端显示乘客位置功能，
所以只有在快车场景下，用户才可以根据需要是否上传自己的位置信息，代码如下：

```java
    /**
     * 快车场景，乘客上传自己位置信息
     *
     * @see TNKLocationManager
     */
    locationManager.setLocationListener(new ILocation.ILocationListener() {
        @Override
        public void onLocationChanged(MapLocation location) {
	    /**
	     * 上传定位点。
	     * 需确保当前订单信息为最新
	     */
            if (tlspManager != null)
                tlspManager.uploadPosition(ConvertHelper.tenPoTOTLSPo(location));
        }

        @Override
        public void onStatusUpdate(String s, int i, String s1) {
        }
    });
```

最后是结束司乘同显服务，代码如下：

```java
    tlspManager.stop();// 结束司乘
```

**乘客端接口回调**，注释见下：

```java
    /**
     * 上传定位点成功
     */
    void onPushPositionSuc();
    /**
     * 上传定位点失败
     */
    void onPushPositionFail(int errCode, String errMsg);
    /**
     * 拉取司机信息成功
     */
    void onPullLsInfoSuc(TLSBRoute route, TLSBOrder order, ArrayList<TLSBDriverPosition> pos);
    /**
     * 拉取司机信息失败
     */
    void onPullLsInfoFail(int errCode, String errMsg);
```
