## 检索SDK

检索sdk为用户提供了sug检索、逆地理编码、驾车路线规划、步行路线规划功能。此sdk需配合support基础库使用，具体版本搭配请参考demo。

### 一、密钥申请

与腾讯地图key一致，如已申请，可直接使用。如未申请，可在[官网申请](https://lbs.qq.com/android_v1/guide-project-setup.html)。如果在官网开启签名校验的方式，检索sdk在初始化时需传入secretKey

<p align="left">
  <img width="550" height="320" src="https://github.com/tentcentmap-mobility/mapmobilitydemo-passenger-Android/blob/master/app/src/main/assets/img/wb_api.png">
</p>

### 二、配置文件

添加权限。需要主要的是在6.0+系统需要动态获取权限。

```java
    <!-- 通过网络得到粗略位置 -->
    <uses-permission android:name="android.permission.ACCESS_COARSE_LOCATION" />
    <!--获取 device id 辨别设备-->
    <uses-permission android:name="android.permission.READ_PHONE_STATE" />
    <!--需要外部存储写权限用于保存地图缓存-->
    <uses-permission android:name="android.permission.WRITE_EXTERNAL_STORAGE" />
    <!--网络-->
    <uses-permission android:name="android.permission.INTERNET" />
```

在build gradle中依赖如下。

```java
    // 检索
    implementation 'com.tencent.map:tencent-navi-search:1.2.1'
    // 基础库
    implementation 'com.tencent.map:tencent-map-nav-surport:1.0.2.4'

```

### 三、初始化

检索sdk在使用时，需进行初始化工作。

```java
    // key:官网申请的key,secretKey:校验的key
    TencentSearchManager.init(mView.getAppContext(), "key", "secretKey");
```

这是sug请求的代码示例：

```java
    TencentSearchManager dataManager = new TencentSearchManager(mView.getAppContext());
    // 添加监听
    dataManager.setSugListener(sugListener);
    // 提供给开发者的sug检索参数配置类
    SugOptions sugOptions = new SugOptions();
    /**
     * policy:设置sug检索策略。
     * <ul>目前仅支持：
     * <li>policy=1：出行场景（网约车） – 起点查询
     * <li>policy=2：出行场景（网约车） – 终点查询
     * </ul>
     *
     * <p>region:设置限制城市范围，根据城市名称限制地域范围。
     * 如，仅获取"广州市"范围内的提示内容，则region = "广州"
     *
     * <p>keyword:设置用户输入的关键词（希望获取后续提示的关键词）。
     * 如，keyword = "南方"
     *
     * <p>location:设置位置，即定位坐标。
     * 传入后，若用户搜索关键词为类别词（如酒店、餐馆时），
     * 与此坐标距离近的地点将靠前显示。
     * 当policy=1时，此参数必填。
     *
     * <p> 更多参数信息，可查看{@link SugOptions}接口文档。
     */
    sugOptions.setPolicy("1")
            .setRegion("北京")
            .setKeyword("之春里")
            .setLocation(new SearchLatLng(40.034852, 116.319820)); 
    dataManager.getSug(sugOptions);
```

这是逆地理的代码示例：

```java
    TencentSearchManager dataManager = new TencentSearchManager(mView.getAppContext());
    // 添加监听
    dataManager.setRegeoListener(regeoListener);
    // 提供给开发者的逆地址解析参数配置类。
    RegeoOptions addressOptions = new RegeoOptions();
    // 设置位置坐标。
    addressOptions.setSearchLatLng(new SearchLatLng(40.034852, 116.319820));
    /**
     * 更多默认参数，参考接口文档{@link RegeoOptions}
     */
    addressOptions.setSearchLatLng(new SearchLatLng(40.034852, 116.319820));
    dataManager.getRegeo(addressOptions);
```

这是驾车路线的代码示例：

```java
    TencentSearchManager dataManager = new TencentSearchManager(mView.getAppContext());
    // 添加监听
    dataManager.setDrivingRouteListener(drivingListener);
    // 提供给开发者的驾车路线规划参数配置类。
    DrivingOptions drivingOptions = new DrivingOptions();
    // 设置起点位置坐标
    drivingOptions.setFrom(new SearchLatLng(40.034852, 116.319820));
    // 设置终点位置坐标
    drivingOptions.setTo(new SearchLatLng(40.034852, 117.319820));
    /**
     * 更多默认参数，可参数接口文档{@link DrivingOptions}
     */
    dataManager.getDriving(drivingOptions);
```

这是步行路线的代码示例：

```java
    TencentSearchManager dataManager = new TencentSearchManager(mView.getAppContext());
    // 添加监听
    dataManager.setWalkingRouteListener(walkingRouteListener);
    // 提供给开发者的步行路线规划参数配置类。
    WalkingOptions walkingOptions = new WalkingOptions();
    // 设置起点位置坐标
    walkingOptions.setFrom(new SearchLatLng(40.034852, 116.319820));
    // 设置终点位置坐标
    walkingOptions.setTo(new SearchLatLng(40.034852, 117.319820));
    /**
     * 更多默认参数，请参考接口文档{@link WalkingOptions}
     */
    dataManager.getWalking(walkingOptions);
```

### 五、混淆

在proguard-rules.pro中添加混淆代码。

```java
    # 检索
    -keep class com.tencent.map.navi.agent.**{*;}
    # support
    com.tencent.navi.surport.**{*;}
```

