## 推荐上车点SDK

推荐上车点sdk是针对于出行场景（推荐上车点）开发的SDK。该sdk为开发者提供了上车点的数据拉取、自定义展示、自动吸附的能力，节约用户的开发成本。此sdk需要配合地图sdk使用。

### 一、密钥申请

与腾讯地图key一致，如已申请，可直接使用。如未申请，可在[官网申请](https://lbs.qq.com/android_v1/guide-project-setup.html)。如果在官网开启签名校验的方式，上车点sdk需要配合使用setWebServiceKey方法。

```java
	// 开启签名校验
        spotManager.setWebServiceKey(“sn key”)
```

<p align="left">
  <img width="550" height="320" src="https://github.com/tentcentmap-mobility/mapmobilitydemo-passenger-Android/blob/master/app/src/main/assets/img/wb_api.png">
</p>

### 二、配置文件

添加权限。需要主要的是在6.0+系统需要动态获取权限。

```java
    <!-- 通过网络得到粗略位置 -->
    <uses-permission android:name="android.permission.ACCESS_COARSE_LOCATION" />
    <!--获取 device id 辨别设备-->
    <uses-permission android:name="android.permission.READ_PHONE_STATE" />
    <!--需要外部存储写权限用于保存地图缓存-->
    <uses-permission android:name="android.permission.WRITE_EXTERNAL_STORAGE" />
```

需要在AndroidMainfest文件中的<application/>节点下添加key。

```java
        <meta-data
            android:name="com.tencent.map.recospot.api_key"
            android:value="上车点key，与地图key一致"
            />
	 <meta-data
            android:name="com.tencent.map.geo.api.key"
            android:value="检索key，与地图key一致"
            />
```

在build gradle中依赖如下。

```java
    // 腾讯地图sdk
    implementation 'com.tencent.map:sdk-compat-v4:4.2.9'
    implementation 'com.tencent.map:tencent-map-vector-sdk:4.2.9'
    // 基础库
    implementation 'com.tencent.map:tencent-map-nav-surport:1.0.2.1'
    // 目前只支持aar方式，需配合地图版本4.2.9          
    implementation files('libs/pickupspot1.0.0.2.aar')
    // 检索sdk
    implementation('com.tencent.map:tencent-navi-search:1.0.0.2') {
        exclude group: 'com.android.support' }
```

### 三、初始化

上车点sdk提供了PointMarkerView默认显示大头针，并实现了相应的加载和跳动动画，但更推荐用户使用marker的方式来实现大头针，因为地图marker可提供点击popWindow。

```java
    <com.tencent.recommendspot.ui.PointMarkerView
        android:id="@+id/point_marker"
        android:layout_width="wrap_content"
        android:layout_height="wrap_content"
        android:layout_centerInParent="true"
        />
```

这是上车点sdk的初始化方法。注意地图的生命周期方法别忘了调用。

```java
	pointMarkerView = findViewById(R.id.point_marker);// 推荐marker的方式
	
	spotManager = new TMMRecommendedBoardManager(tencentMap);
        TMMRecommendedBoardManager.mContext = this;
	
	/**
         * 关联cameraChange监听
         */
        tencentMap.setOnCameraChangeListener(new TencentMap.OnCameraChangeListener() {
            @Override
            public void onCameraChange(CameraPosition cameraPosition) {
                spotManager.onCamerChangeListener(cameraPosition);
            }

            @Override
            public void onCameraChangeFinished(CameraPosition cameraPosition) {
                spotManager.onCameraChangeFinish(cameraPosition);
            }
        });
```

请求数据。需要注意的是，在sdk内部已经对map onCameraChanged进行了监听，当地图移动会自动请求数据。

```java
        // 发起请求
	spotManager.getRecommendSpot(spotManager.getBoardOption()
                .latlng(latLng));
```

### 四、参数配置

这是TMMRecommendedBoardManager的方法列表，部分使用方法示例如下。

```java
	public void clear(View view) {
            if(pickupSpotManager != null)
                spotManager.removeSpotMarkers();// 移除当前上车点
        }
	public void register() {
	    spotManager.registerRecommendSpotListener(new TMMRBDataManager.TMMRecommendedBoardListener() {
                @Override
                public void onRecommendspotSuc(List<TMMRecommendSpotBean.BoardingPointBean> bpBeans) {
                    Log.e("tag1234", "上车点 bpBeans : " + bpBeans.toString());
                }

                @Override
                public void onRecommendspotFail(int errorCode, String errorMsg) {
                    Log.e("tag1234", "上车点 errorCode : " + errorCode + ", errorMsg : " + errorMsg);
                }
            });
	}
```

具体方法列表见下。

|   方法名   |   含义   |
| ---- | ---- |
|   removeSpotMarkers()   |   移除当前上车点   |
|   isOpen(boolean isOpen)  |   是否使用上车点   |
|   setWebServiceKey(String snkey)   |   签名校验  |
|   destory()   |   销毁  |
|   getRecommendSpot(TMMRecommendedBoardOption option)  |   请求上车点数据   |
|   registerRecommendSpotListener(TMMRecommendedBoardListener listener)   |   请求上车点数据监听   |
|   unRegisterRecommendSpotListener(TMMRecommendedBoardListener listener)   |   移除监听   |
|   registerTraHubListener(TMMTransportationHubListener listener)   |   请求大型枢纽数据监听   |
|   unRegisterTraHubListener()   |   移除监听   |
|   setOnAttachRecommendSpotListener(TMMAttachRecommendSpotListener listener)   |   吸附状态监听   |
|   removeAttachRecommendSpotListener()   |   移除监听   |
|   getSubHubDataById(String hubId)   |   获取特定二级枢纽数据   |
|   registerSubHubListener(TMMSubHubListener listener)   |   二级枢纽数据监听   |
|   removeSubListener(TMMSubHubListener listener)   |   移除监听   |
|   onCamerChangeListener(CameraPosition cameraPosition)   |   关联地图onCamerChange   |
|   onCameraChangeFinish(CameraPosition cameraPosition)   |   关联地图onCameraChangeFinish   |
|   setPointAnimaListener(TMMPointAnimaListener listener)   |   大头针动画状态监听   |

这是TMMPointAnimaListener配合PointMarkerView的使用方法，代码使用如下。

```java
    void handleAnima() {
        if(pointMarkerView == null || pointMarkerView == null)
            return;
        spotManager.setPointAnimaListener(new TMMRecommendedBoardManager.TMMPointAnimaListener() {
            @Override
            public void startLoadingAnima() {
                pointMarkerView.startLoadingAnima();
            }

            @Override
            public void stopLoadingAnima() {
                pointMarkerView.stopLoadingAnima();
            }

            @Override
            public void startRippleAnima() {
                pointMarkerView.startRippleAnima();
            }

            @Override
            public void stopRippleAnima() {
                pointMarkerView.stopRippleAnima();
            }

            @Override
            public ObjectAnimator transactionAnimWithMarker() {
                if(pointMarkerView != null)
                    return pointMarkerView.transactionAnimWithMarker();
                return null;
            }
        });
    }
```

TMMPointAnimaListener具体接口见下表。注意：使用默认UI时的状态回调。

|   方法名   |   含义   |
| ---- | ---- |
|   startLoadingAnima()   |   开始加载动画状态回调   |
|   stopLoadingAnima()   |   结束加载动画状态回调   |
|   startRippleAnima()    |   开始波纹动画回调   |
|   stopRippleAnima()   |   结束波纹动画回调   |
|   transactionAnimWithMarker()  |    对跳动动画的ObjectAnimator监听   |

#### 常规属性

这是对TMMRecommendedBoardManager进行的常规属性配置的方法。

```java
        spotManager.getManagerConfig()
	    .setMinMapZoomLevel(16)// 展示上车点的最小地图级别
            .isAbsorbed(true)// 是否吸附
            .setAbsorbThreshHold(50)// 吸附阈值
            .isTraHubVisiable(true) // 是否使用大型枢纽接口
            .isRecommendSpotDefaultUI(true); // 是否使用默认推荐上车点UI

```

这是TMMRecommendedBoardManagerConfig具体方法作用列表。

|   方法名   |   含义   |
| ---- | ---- |
|   isOpen(boolean isOpen)   |   是否使用上车点，默认true   |
|   setMinMapZoomLevel(int minMapZoomLevel)   |   展示上车点的最小地图级别，默认16   |
|   isAbsorbed(boolean isAbsorbed)    |   是否进行吸附，默认true   |
|   setAbsorbThreshHold(int absorbThreshHold)   |   自动吸附距离阈值，默认50米   |
|   isTraHubVisiable(boolean isTraHubVisiable)  |    是否展示交通枢纽和请求数据，默认true   |
|   isRecommendSpotDefaultUI(boolean isRecommendSpotDefaultUI)   |   是否使用默认上车点UI，默认true   |

#### 请求参数

这是对TMMRecommendedBoardManager进行的请求参数配置的方法。

```java
        spotManager.getBoardOption()
	    .limit(3)
	    .latlng(latlng);

```

这是TMMRecommendedBoardOption具体方法作用列表。

|   方法名   |   含义   |
| ---- | ---- |
|   limit(int limit)   |   请求上车点的个数，默认3（最大5）   |
|   latlng(TMMLatlng latlng)   |   待请求的经纬度   |

#### UI属性

这是对TMMRecommendedBoardManager进行的上车点UI配置的方法。

```java
        spotManager.getUiStyle()
	    .setTextSize(CommentUtils.sp2px(mContext.getApplicationContext(), 13))// 上车点字体大小
            .setTextColor(0xFF3cbca3)// 上车点文字颜色
            .setMaxWordsPerLine(8);// 单行最大字数
```
这是TMMUIStyle具体方法作用列表。

|   方法名   |   含义   |
| ---- | ---- |
|   setDotIcon(int dotIcon, int dotIconRadius)   |   R.drawable.xxx,推荐上⻋点的原点图片，圆点半径:默认3dp   |
|   setTextSize(float textSize)   |   上车点字体大小，默认13sp   |
|   setTextColor(int textColor)   |   上车点文字颜色，默认0xFF3cbca3   |
|   setBorderSize(int borderSize)   |   推荐上⻋点文字边界宽度，单位dp，默认2dp   |
|   setBorderColor(int borderColor)   |   上车点边界颜色，默认0xFFFFFFFF   |
|   setDistance(int distance)   |   圆点与文字间的距离，3dp   |
|   setTraHubColor(int traHubColor)   |   大型枢纽的块颜色，默认0x593977FE   |
|   setTraHubEdgeColor(int traHubEdgeColor)   |   大型枢纽的边颜色，默认0x3977FE   |
|   setTraHubEdgeWidth(int traHubEdgeWidth)   |   大型枢纽的边宽度   |
|   setMaxWordsPerLine(int maxWordsPerLine)   |   每行的最大字数，超过换行，默认8   |

### 五、混淆

在proguard-rules.pro中添加混淆代码。

```java
    # 地图
    -keep class com.tencent.tencentmap.**{*;}
    -keep class com.tencent.map.**{*;}
    -keep class com.tencent.beacontmap.**{*;}
    -keep class com.tencent.tencentmap.mapsdk.maps.BaseMapView{*;}
    -keep class navsns.**{*;}
    -dontwarn com.qq.**
    -dontwarn com.tencent.beacon.**
    # 上车点
    -keep class com.tencent.recommendspot.**{*;}
```
