//
//  MapUtil.m
//  NaviKitDemo
//
//  Created by mol on 2022/11/16.
//

#import "MapUtil.h"
#import <QMapKit/QMapKit.h>

@implementation MapUtil

+ (NSString *)tnk_distanceToString:(int)distance
{
    if (distance >= 1E6)
    {
        return [NSString stringWithFormat:@"%d",(int)(distance / 1000)];
    }
    else if (distance >= 1000)
    {
        NSString *distanceString = [NSString stringWithFormat:@"%.1lf", ((double) distance / 1000)];
        if ([[distanceString substringFromIndex:distanceString.length-2] isEqual:@".0"])
        {
             distanceString = [distanceString substringToIndex:distanceString.length - 2];
        }
        
        return [NSString stringWithFormat:@"%@", distanceString];
    }
    else
    {
        return [NSString stringWithFormat:@"%d",(int)distance];
    }
}

+ (NSString *)tnk_distanceToStringUnit:(int)distance {
    return distance >= 1000 ? @"公里" : @"米";
}


+ (NSString *)tnk_timeToString:(int)minutes {
    NSString *timeString = @"";
    
    if (minutes >= 24 * 60)
    {
        timeString = [timeString stringByAppendingFormat:@"%d天", (int)(minutes/(24 * 60))];
        minutes = minutes % (24 *60);
    }
    
    if (minutes >= 60) {
        timeString = [timeString stringByAppendingFormat:@"%d小时", (int)(minutes/60)];
        minutes = minutes % 60;
    }
    
    if (minutes != 0) {
        timeString = [timeString stringByAppendingFormat:@"%d分钟", (int)minutes];
    }
    
    return timeString;
}

// 两点之间距离
+ (double)distanceBetween:(CLLocationCoordinate2D)coordianteA coordianteB:(CLLocationCoordinate2D)coordianteB {
    return QMetersBetweenCoordinates(coordianteA, coordianteB);
}

@end
