//
//  DeviceUtil.m
//  NaviKitDemo
//
//  Created by mol on 2022/11/14.
//

#import "DeviceUtil.h"
#import <UIKit/UIKit.h>

@implementation DeviceUtil

+ (CGFloat)TopNotchHeight {
    
    CGFloat topPadding = 0;
    if (@available(iOS 11.0, *)) {
        UIWindow *window = UIApplication.sharedApplication.windows.firstObject;
        switch ([UIApplication sharedApplication].statusBarOrientation) {
            case UIInterfaceOrientationPortrait:
                topPadding = window.safeAreaInsets.top;
                break;
            case UIInterfaceOrientationLandscapeRight:
                topPadding = window.safeAreaInsets.left;
                break;
            case UIInterfaceOrientationPortraitUpsideDown:
                topPadding = window.safeAreaInsets.bottom;
                break;
            case UIInterfaceOrientationLandscapeLeft:
                topPadding = window.safeAreaInsets.right;
                break;
            default:
                break;
        }
    }
    
    return topPadding;
}

+ (CGFloat)topPadding {
    CGFloat topPadding = 0;
    if (@available(iOS 11.0, *)) {
        UIWindow *window = UIApplication.sharedApplication.windows.firstObject;
        topPadding = window.safeAreaInsets.top;
    }
    
    return topPadding;
}

+ (CGFloat)bottomPadding {
    CGFloat bottomPadding = 0;
    if (@available(iOS 11.0, *)) {
        UIWindow *window = UIApplication.sharedApplication.windows.firstObject;
        bottomPadding = window.safeAreaInsets.bottom;
    }
    
    return bottomPadding;
}

static UIInterfaceOrientation gCurrentOrientation = UIInterfaceOrientationPortrait;
+ (UIInterfaceOrientation)currentOrientation {
    return gCurrentOrientation;    
}

+ (void)setCurrentOrientation:(UIInterfaceOrientation)currentOrientation {
    gCurrentOrientation = currentOrientation;
    
    NSNumber *value = [NSNumber numberWithInt:currentOrientation];
    [[UIDevice currentDevice] setValue:value forKey:@"orientation"];
    [UIViewController attemptRotationToDeviceOrientation];
}

@end
