//
//  WebRoutePolyline.m
//  NaviKitDemo
//
//  Created by mol on 2022/12/19.
//

#import "WebRoutePolyline.h"
#import <QMapKit/QMSSearcher.h>
#import <TencentNavKit/TencentNavKit.h>

@implementation WebRoutePolyline

- (id)initWithDriveRoute:(QMSRoutePlan *)driveRoute {
    
    NSArray *points = driveRoute.polyline;
    NSUInteger pointCount = driveRoute.polyline.count;

    
    CLLocationCoordinate2D *coordinates = (CLLocationCoordinate2D*)malloc(sizeof(CLLocationCoordinate2D)*pointCount);
    for (int i = 0; i < pointCount; ++i) {
        NSValue *value = points[i];
        CLLocationCoordinate2D coordinate = [value coordinateValue];
        coordinates[i] = coordinate;
    }
       
    if (pointCount == 0) {
        return nil;
    }
    
    self = [super initWithCoordinates:coordinates count:pointCount];
    
    free(coordinates);

    if (self) {
        _driveRoute = driveRoute;
        _arrLine = [NSMutableArray array];
    }
    
    return self;
}


- (void)setSelectedLine:(BOOL)selectedLine {
    _selectedLine = selectedLine;
    
    NSMutableArray* routeLineArray = [NSMutableArray array];
    QSegmentColor *subLine = [[QSegmentColor alloc] init];
    subLine.startIndex = 0;
    subLine.endIndex = (int)self.pointCount - 1;

    subLine.color = _selectedLine ? TNKRouteTrafficStatusColor(TNKRouteTrafficDataStatusSmooth) : TNKAccompanyRouteTrafficStatusColor(TNKRouteTrafficDataStatusSmooth);
    subLine.borderColor = _selectedLine ? TNKRouteTrafficStatusBorderColor(TNKRouteTrafficDataStatusSmooth) : TNKAccompanyRouteTrafficStatusBorderColor(TNKRouteTrafficDataStatusSmooth);
    
    [routeLineArray addObject:subLine];
    [_arrLine setArray:routeLineArray];
}


@end
