//
//  TrafficPolyline.m
//  TNKNavigation
//
//  Created by fan on 2018/3/28.
//  Copyright © 2018年 Tencent. All rights reserved.
//

#import "RoutePolyline.h"
#import <TencentNavKit/TencentNavKit.h>

@implementation RoutePolyline

- (id)initWithDriveRoute:(TNKDriveRoute *)driveRoute {
    
    NSUInteger pointCount = driveRoute.routePoints.count;
    CLLocationCoordinate2D *coordinates = (CLLocationCoordinate2D*)malloc(sizeof(CLLocationCoordinate2D)*pointCount);
    for (int i = 0; i < pointCount; ++i) {
        coordinates[i] = [driveRoute.routePoints objectAtIndex:i].coordinate;
    }
       
    if (pointCount == 0) {
        return nil;
    }
    
    self = [super initWithCoordinates:coordinates count:pointCount];
    
    free(coordinates);

    if (self) {
        _arrLine = [NSMutableArray array];
        
        self.trafficItems = driveRoute.routeTrafficItems;
    }
    
    return self;
}



- (void)setSelectedLine:(BOOL)selectedLine {
    if (_selectedLine == selectedLine) {
        return;
    }
    _selectedLine = selectedLine;
    
    self.trafficItems = self.trafficItems;
}

- (void)setTrafficItems:(NSArray<TNKRouteTrafficItem *> *)trafficItems {

    _trafficItems = trafficItems;
    
    NSMutableArray* routeLineArray = [NSMutableArray array];
    for (TNKRouteTrafficItem *trafficItem in trafficItems) {
        QSegmentColor *subLine = [[QSegmentColor alloc] init];
        subLine.startIndex = (int)trafficItem.from;
        subLine.endIndex   = (int)trafficItem.to;

        subLine.color = _selectedLine ? TNKRouteTrafficStatusColor(trafficItem.trafficStatus) : TNKAccompanyRouteTrafficStatusColor(trafficItem.trafficStatus);
        subLine.borderColor = _selectedLine ? TNKRouteTrafficStatusBorderColor(trafficItem.trafficStatus) : TNKAccompanyRouteTrafficStatusBorderColor(trafficItem.trafficStatus);
        
        [routeLineArray addObject:subLine];
    }
    
    [_arrLine setArray:routeLineArray];
}

@end
