//
//  TrafficPolyline.h
//  TNKNavigation
//
//  Created by fan on 2018/3/28.
//  Copyright © 2018年 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <QMapKit/QMapKit.h>

NS_ASSUME_NONNULL_BEGIN

@class TNKRouteTrafficItem, TNKDriveRoute;


/// 路线
@interface RoutePolyline : QPolyline

- (id)initWithDriveRoute:(TNKDriveRoute *)driveRoute;

/** @brief 每一条路线的所有分段信息**/
@property (nonatomic, readonly) NSMutableArray<QSegmentColor *>* arrLine;

@property (nonatomic, readonly) QText *texts;

@property (nonatomic, assign) BOOL selectedLine;

@property (nonatomic, copy) NSArray <TNKRouteTrafficItem *> *trafficItems;

@end


NS_ASSUME_NONNULL_END
