//
//  SearchPOIModel.m
//  NaviKitDemo
//
//  Created by mol on 2022/11/14.
//

#import "RoutePlanPOIModel.h"

@implementation RoutePlanPOIModel

- (instancetype)initWithPOIModel:(POIModel *)poiModel {
    self = [super init];
    if (self) {
        _poiModel = poiModel;
    }
    
    return self;
}

- (NSString *)descText {
    if (_poiModel.title.length > 0) {
        return _poiModel.title;;
    }
    
    if (self.useMyLocation) {
        return @"我的位置";
    }
    
    return [NSString stringWithFormat:@"%.6f,%.6f", _poiModel.coordinate.longitude, _poiModel.coordinate.latitude];
}

@end
