//
//  SearchPOIModel.h
//  NaviKitDemo
//
//  Created by mol on 2022/11/14.
//

#import "POIModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface RoutePlanPOIModel : NSObject

@property (nonatomic, readonly) POIModel *poiModel;

/// 对点的描述
@property (nonatomic, readonly) NSString *descText;

/// 检索时的唯一标识
@property (nonatomic, copy) NSString *searchID;

/// 是否使用当前定位
@property (nonatomic, assign) BOOL useMyLocation;

- (instancetype)initWithPOIModel:(POIModel *)poiModel;
- (instancetype)init NS_UNAVAILABLE;
@end

NS_ASSUME_NONNULL_END
