//
//  CommonObj.h
//  NaviKitDemo
//
//  Created by mol on 2022/11/14.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import "RoutePlanPOIModel.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, MapVendor) {
    MapVendorTencent,
};

typedef NS_ENUM(NSInteger, TheTravelMode) {
    TheTravelModeDriving  = 0,  ///< 驾车
    TheTravelModeWalking  = 1,  ///< 步行
    TheTravelModeRiding   = 2,  ///< 骑行
};  ///< 出行方式

@class TNKDriveRouteExplain,
TNKSegmentItem;

@interface TheLocationCoordinate : NSObject

@property (nonatomic, assign) CLLocationCoordinate2D coordinate;

@end


@interface TheRouteTrafficItem : NSObject

/**
 * @brief 该段路线距离。单位：米
 */
@property (nonatomic, assign) int distance;

/**
 * @brief 该段路线起点在路线点串中的索引. 索引值从0开始, 若该段为偏航前行驶部分, 则索引值为-1. 绘制导航路况线时请将第一段剔除.
 */
@property (nonatomic, assign) int from;

/**
 * @brief 该段路线终点在路线点串中的索引. 若该段为偏航前行驶部分, 则索引值为0.
 */
@property (nonatomic, assign) int to;

/**
 * @brief 该段路况状态 0:通畅 1:缓行 2:堵塞 3:未知路况 4:严重堵塞.
 */
@property (nonatomic, assign) int trafficStatus;

@end

@interface TheDriveRoute : NSObject
/**
 * @brief 路线标签。比如：时间段、距离短等。
 */
@property (nonatomic, copy) NSString *recommendReason;

/**
 * @brief 组成路线形状的坐标点数组
 */
@property (nonatomic, copy) NSArray<TheLocationCoordinate *> *routePoints;

/**
 * @brief 路线ID
 */
@property (nonatomic, copy) NSString *routeID;

/**
 * @brief 总距离. 单位，米
 */
@property (nonatomic, assign) int totalDistance;

/**
 * @brief 总预计时间. 单位，分钟
 */
@property (nonatomic, assign) int totalTime;

/**
 * @brief 路线红绿灯个数
 */
@property (nonatomic, assign) int trafficLightCount;

/**
 * @brief 路线预计所需高速费 单位: 元
 */
@property (nonatomic, assign) int fee;

/**
 * @brief 导航起点
 */
@property (nonatomic, strong) RoutePlanPOIModel *origin;

/**
 * @brief 导航终点
 */
@property (nonatomic, strong) RoutePlanPOIModel *destination;

/**
 * @brief 路线规划时的路况状态数据.
 */
@property (nonatomic, copy) NSArray <TheRouteTrafficItem *> *routeTrafficItems;


@property (nonatomic, copy) NSArray <TNKSegmentItem *> *segmentItems;

/**
 * @brief 路线解释性信息. since 5.2.4
 */
@property (nonatomic, strong, nullable) NSArray <TNKDriveRouteExplain *> *routeExplainItems;

@end

@interface TheDriveRouteSearchResult : NSObject
/**
 * @brief 路线数组，最多三个
 */
@property (nonatomic, copy) NSArray<TheDriveRoute *> *routes;

/**
 * @brief 路线还原是否成功。如果成功，routes的第一个路线为还原路线
 */
@property (nonatomic, assign) BOOL isSearchByRouteIDWorking;

/**
 * @brief 导航的会话id.
 * @since 5.4.1
 */
@property (nonatomic, copy) NSString *naviSessionID;

@end

NS_ASSUME_NONNULL_END
