//
//  ViewController.m
//  TencentNavSDKDemo
//
//  Created by mol on 2023/2/17.
//

#import "MainViewController.h"

NSString * const kMainMenuSectionTitle = @"title";
NSString * const kMainMenuSectionItems = @"items";

NSString * const kMainMenuTitle = @"title";
NSString * const kMainMenuClassName = @"class";

@interface MainViewController () <UINavigationBarDelegate, UINavigationControllerDelegate>

@property(nonatomic, copy) NSArray<NSDictionary<NSString *, id> *> *menuList;

@end

@implementation MainViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.menuList = @[
        @{
            kMainMenuSectionTitle : @"驾车功能",
            kMainMenuSectionItems : @[
                @{kMainMenuTitle : @"驾车路径规划",
                  kMainMenuClassName : @"DriveRoutePlaneCaseController",
                },
                @{
                    kMainMenuTitle : @"货车路径规划",
                    kMainMenuClassName : @"TruckRoutePlanController",
                },
                @{
                    kMainMenuTitle : @"货车限行信息",
                    kMainMenuClassName : @"TruckRestrictionInfoViewController",
                },
                @{kMainMenuTitle : @"驾车模拟导航",
                  kMainMenuClassName : @"DriveSimlulationCaseController",
                },
                @{kMainMenuTitle : @"自定义导航面板",
                  kMainMenuClassName : @"DriveCustomPanelController",
                },
                @{kMainMenuTitle : @"自定义导航光柱图",
                  kMainMenuClassName : @"DriveCustomTrafficBarController",
                },
                @{
                    kMainMenuTitle : @"默认导航光柱图",
                    kMainMenuClassName : @"DriveTrafficBarController",
                },
                @{kMainMenuTitle : @"自定义起终点样式",
                  kMainMenuClassName : @"DriveCustomODMarkerController",
                },
                @{kMainMenuTitle : @"自定义途经点样式",
                  kMainMenuClassName : @"DriveCustomWaypointMarkerCaseController",
                },
                @{kMainMenuTitle : @"自定义自车标",
                  kMainMenuClassName : @"DriveCustomUserLocationController",
                },
                @{kMainMenuTitle : @"自定义路线样式",
                  kMainMenuClassName : @"DriveCustomRouteConfigCaseController",
                },
                @{kMainMenuTitle : @"导航中隐藏导航元素",
                  kMainMenuClassName : @"DismissUIWhenNavigatingController",
                },
                @{kMainMenuTitle : @"自定义放大图",
                  kMainMenuClassName : @"EnlargedMapCaseController",
                },
                @{kMainMenuTitle : @"全览模式额外显示点",
                  kMainMenuClassName : @"ExtraPointForOverviewController",
                },
                @{kMainMenuTitle : @"自定义规避区域",
                  kMainMenuClassName : @"DriveAvoidAreaController",
                },
                @{kMainMenuTitle : @"驾车轨迹回放",
                  kMainMenuClassName : @"DriveLocationReplayViewController",
                },
                @{kMainMenuTitle : @"自定义转向箭头",
                  kMainMenuClassName : @"CustomTurnArrowController",
                },
                @{kMainMenuTitle : @"自定义锁车模式",
                  kMainMenuClassName : @"DriveCustomFollowModeController",
                },
                @{kMainMenuTitle : @"自定义横屏模式",
                  kMainMenuClassName : @"DriveLandscapeModeController",
                },
            ],
        },
        @{
            kMainMenuSectionTitle : @"步行功能",
            kMainMenuSectionItems : @[
                @{kMainMenuTitle : @"步行模拟导航",
                  kMainMenuClassName : @"WalkNavController",
                },
            ],
        },
        @{
            kMainMenuSectionTitle : @"骑行功能",
            kMainMenuSectionItems : @[
                @{kMainMenuTitle : @"骑行导航",
                  kMainMenuClassName : @"RideNavController",
                },
                @{kMainMenuTitle : @"骑行模拟导航",
                  kMainMenuClassName : @"RideNavSimulationController",
                },
            ],
        },
    ];
        
    [self.tableView reloadData];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    [self.navigationController setNavigationBarHidden:NO animated:YES];
}


#pragma mark - UITableViewDelegate, UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return self.menuList.count;
}

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    NSString *title = self.menuList[section][kMainMenuSectionTitle];
    return title;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    NSArray<NSDictionary<NSString *,NSString *> *> *items = self.menuList[section][kMainMenuSectionItems];
    return items.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *CellIdentifier = @"Cell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier];
        if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
    }
    NSArray<NSDictionary<NSString *,NSString *> *> *items = self.menuList[indexPath.section][kMainMenuSectionItems];
    cell.textLabel.text = [items objectAtIndex:indexPath.row][kMainMenuTitle];
    cell.detailTextLabel.text = [items objectAtIndex:indexPath.row][kMainMenuClassName];
    
    return cell;
}

#pragma mark -- didSeclectRowAtIndex
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    NSArray<NSDictionary<NSString *,NSString *> *> *items = self.menuList[indexPath.section][kMainMenuSectionItems];
    NSString *className = [items objectAtIndex:indexPath.row][kMainMenuClassName];
    UIViewController *vc = [[NSClassFromString(className) alloc] init];
    vc.title = [items objectAtIndex:indexPath.row][kMainMenuTitle];
    [self.navigationController pushViewController:vc animated:YES];
}



@end
