//
//  WalkNavController.m
//  NaviKitDemo
//
//  Created by mol on 2022/10/26.
//

#import "WalkNavController.h"
#import <TencentNavKit/TencentNavKit.h>
#import <TNKAudioPlayer/TNKAudioPlayer.h>

@interface WalkNavController ()  <TNKWalkNavDelegate, TNKWalkNavViewDelegate>

@property (nonatomic, strong) TNKWalkNavManager *naviManager;
@property (nonatomic, strong) TNKWalkNavView *naviView;

@property (nonatomic, strong) TencentLBSLocation *latestLocation;
@end
@implementation WalkNavController

- (void)dealloc {
    [self.naviManager unregisterAllNavDelegates];
    [self.naviManager stopNav];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.naviManager = [TNKWalkNavManager sharedInstance];
    self.naviManager.locationSimulator.simulationSpeed = 10;
    self.naviManager.audioPlayer = [TNKAudioPlayer sharedAudioPlayer];
    self.naviView = [[TNKWalkNavView alloc] initWithFrame:self.view.bounds];
    self.naviView.showUIElements = YES;
    self.naviView.delegate = self;
    [self.naviView updateRedLineConfig:[[TNKRedLineConfig alloc] init]];
    [self.view addSubview:self.naviView];
    
    [self.naviManager registerNavDelegate:self.naviView];
    [self.naviManager registerNavDelegate:self];

    [self planningRoute];
}

#pragma mark - private

- (void)planningRoute {
    
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    TNKSearchNavPoint *dest = [[TNKSearchNavPoint alloc] init];
    dest.coordinate = CLLocationCoordinate2DMake(39.970263, 116.424866);
    request.destination = dest;

    TNKSearchNavPoint *orig = [[TNKSearchNavPoint alloc] init];
    orig.coordinate = CLLocationCoordinate2DMake(39.978629, 116.424630);
    request.origin = orig;
    
    request.searchOption = [[TNKDriveRouteSearchOption alloc] init];

    __weak typeof(self) weakself = self;
    [self.naviManager searchRoutesWithRequest:request completion:^(TNKWalkRouteSearchResult * _Nullable routesRsp,
                                                                   NSError * _Nullable error) {
        if (error != nil) {
            return;
        }
        weakself.naviManager.locationSimulator.enabled = YES;
        [weakself.naviManager startNavWithIndex:0];
        //        [weakself.naviManager startWithRouteID:routesRsp.routes.firstObject.routeID];
    }];
}


#pragma mark - TNKWalkNavDelegate

- (void)walkNavManagerDidStart:(TNKWalkNavManager *)manager {
    
}

- (void)walkNavManagerDidStop:(TNKWalkNavManager *)manager {
    
}

- (void)walkNavManager:(TNKWalkNavManager *)manager didStartRerouting:(TNKRerouteReason)rerouteReason {
    
}

- (void)walkNavManager:(TNKWalkNavManager *)manager updateNavigationData:(TNKWalkNavigationData *)navigationData {
    
}

- (void)walkNavManager:(TNKWalkNavManager *)manager didUpdateLocation:(TNKLocation *)location {
    
}

#pragma mark - TNKWalkNavViewDelegate

- (void)navViewCloseButtonClicked:(TNKBaseNavView *)navView {
    [self.naviManager stopNav];
    [self.naviView clearAllRouteUI];
}
@end
