//
//  RideNavSimulationController.m
//  TencentNavSDKDemo
//
//  Created by halldwang on 2024/11/7.
//

#import "RideNavSimulationController.h"

#import <TencentNavKit/TencentNavKit.h>
#import <TNKAudioPlayer/TNKAudioPlayer.h>

@interface RideNavSimulationController ()  <TNKRideNavDelegate, TNKRideNavViewDelegate>

@property (nonatomic, strong) TNKRideNavManager *naviManager;
@property (nonatomic, strong) TNKRideNavView *naviView;

@property (nonatomic, strong) TencentLBSLocation *latestLocation;
@end
@implementation RideNavSimulationController

- (void)dealloc {
    [self.naviManager unregisterAllNavDelegates];
    [self.naviManager stopNav];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.naviManager = [TNKRideNavManager sharedInstance];
    self.naviManager.locationSimulator.simulationSpeed = 20;
    self.naviManager.audioPlayer = [TNKAudioPlayer sharedAudioPlayer];
    self.naviView = [[TNKRideNavView alloc] initWithFrame:self.view.bounds];
    self.naviView.showUIElements = YES;
    self.naviView.delegate = self;
    [self.naviView updateRedLineConfig:[[TNKRedLineConfig alloc] init]];
    [self.view addSubview:self.naviView];
    
    [self.naviManager registerNavDelegate:self.naviView];
    [self.naviManager registerNavDelegate:self];

    [self planningRoute];
}

#pragma mark - private

- (void)planningRoute {
    
  TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];

  TNKSearchNavPoint *orig = [[TNKSearchNavPoint alloc] init];
  orig.coordinate = CLLocationCoordinate2DMake(40.007775,116.390286);
  request.origin = orig;

  TNKSearchNavPoint *dest = [[TNKSearchNavPoint alloc] init];
  dest.coordinate = CLLocationCoordinate2DMake(39.507517,116.413965);
  request.destination = dest;
  
  request.searchOption = [[TNKDriveRouteSearchOption alloc] init];

  __weak typeof(self) weakself = self;
  [self.naviManager searchRoutesWithRequest:request completion:^(TNKRideRouteSearchResult * _Nullable routesRsp,
                                                                 NSError * _Nullable error) {
      if (error != nil) {
          return;
      }
      
      weakself.naviManager.locationSimulator.enabled = YES;
      [weakself.naviManager startNavWithIndex:0];
      //        [weakself.naviManager startWithRouteID:routesRsp.routes.firstObject.routeID];
  }];
}

#pragma mark - TNKRideNavDelegate

- (void)rideNavManagerDidStart:(TNKRideNavManager *)manager {
    
}

- (void)rideNavManagerDidStop:(TNKRideNavManager *)manager {
    
}

- (void)rideNavManager:(TNKRideNavManager *)manager didStartRerouting:(TNKRerouteReason)rerouteReason {
    
}

- (void)rideNavManager:(TNKRideNavManager *)manager updateNavigationData:(TNKRideNavigationData *)navigationData {
    
}

- (void)rideNavManager:(TNKRideNavManager *)manager didUpdateLocation:(TNKLocation *)location {
      NSLog(@"RideNavSimulationController rideNavManager didUpdateLocation=%@", location);
}

#pragma mark - TNKRideNavViewDelegate

- (void)navViewCloseButtonClicked:(TNKBaseNavView *)navView {
    [self.naviManager stopNav];
    [self.naviView clearAllRouteUI];
}
@end
