//
//  RideNavController.m
//  NaviKitDemo
//
//  Created by mol on 2022/10/27.
//

#import "RideNavController.h"
#import <TencentLBS/TencentLBS.h>

#import <TencentNavKit/TencentNavKit.h>
#import <TNKAudioPlayer/TNKAudioPlayer.h>

@interface RideNavController ()  <TNKRideNavDelegate, TNKRideNavViewDelegate>

@property (nonatomic, strong) TNKRideNavManager *naviManager;
@property (nonatomic, strong) TNKRideNavView *naviView;

@property (nonatomic, strong) TencentLBSLocation *latestLocation;

// 定位管理类
@property (nonatomic, strong) TencentLBSLocationManager *locationManager;
// 是否获得了定位点
@property (nonatomic, assign) BOOL hasFirstLocation;
// 导航前记录最近的50个定位点，导航算路时做为前序点参数传入，以提高起点准确性
@property (nonatomic, strong) NSMutableArray<TencentLBSLocation *> *locations;

@end
@implementation RideNavController

- (void)dealloc {
  // 记得停止定位
    [self.locationManager stopUpdatingLocation];
    [self.locationManager stopUpdatingHeading];
  
    [self.naviManager unregisterAllNavDelegates];
    [self.naviManager stopNav];
}

- (void)viewDidLoad {
    [super viewDidLoad];
  self.locations = [NSMutableArray array];
  // 开启定位
  [self startLocationManager];
    // Do any additional setup after loading the view.

  self.naviManager = [TNKRideNavManager sharedInstance];
  self.naviManager.audioPlayer = [TNKAudioPlayer sharedAudioPlayer];
  self.naviView = [[TNKRideNavView alloc] initWithFrame:self.view.bounds];
  self.naviView.showUIElements = YES;
  self.naviView.delegate = self;
  [self.naviView updateRedLineConfig:[[TNKRedLineConfig alloc] init]];
  [self.view addSubview:self.naviView];
  
  [self.naviManager registerNavDelegate:self.naviView];
  [self.naviManager registerNavDelegate:self];
  
  if (self.locations.count == 0) {
    
    dispatch_time_t delayTime = dispatch_time(DISPATCH_TIME_NOW, (int64_t)(2.0 * NSEC_PER_SEC));
    dispatch_block_t executeBlock = ^{
              NSLog(@"延迟2秒等待定位完成执行的代码");
      [self planningRoute];
          };
    dispatch_after(delayTime, dispatch_get_main_queue(), executeBlock);
    
  }
  
}


- (void)startLocationManager {
    
  self.locationManager = [[TencentLBSLocationManager alloc] init];
  // 设置定位的key，可以使用与地图SDK相同的key
  self.locationManager.apiKey = [QMapServices sharedServices].APIKey;
  NSLog(@"[QMapServices sharedServices].APIKey %@", [QMapServices sharedServices].APIKey);
  // 监听定位信息
  self.locationManager.delegate = self;
  self.locationManager.allowsBackgroundLocationUpdates = YES;

  // 申请的定位权限，得和在info.list申请的权限对应才有效
  CLAuthorizationStatus authorizationStatus = [CLLocationManager authorizationStatus];
  if (authorizationStatus == kCLAuthorizationStatusNotDetermined) {
      [self.locationManager requestWhenInUseAuthorization];
  } else if (authorizationStatus == kCLAuthorizationStatusDenied) {
    NSLog(@"请去手机设置页面开启定位权限");
  }
  
  // 开启定位
  [self.locationManager startUpdatingLocation];
  [self.locationManager startUpdatingHeading];
  
}

#pragma mark - private

- (void)planningRoute {
  if (self.locations.count == 0) {
    NSLog(@"没有获得定位点，无法算路");
  }
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];

    TNKSearchNavPoint *orig = [[TNKSearchNavPoint alloc] init];
    orig.coordinate = self.locations.lastObject.location.coordinate;
    request.origin = orig;
  
    TNKSearchNavPoint *dest = [[TNKSearchNavPoint alloc] init];
    dest.coordinate = CLLocationCoordinate2DMake(39.915463,116.411224);
    request.destination = dest;
    
    request.searchOption = [[TNKDriveRouteSearchOption alloc] init];

    __weak typeof(self) weakself = self;
    [self.naviManager searchRoutesWithRequest:request completion:^(TNKRideRouteSearchResult * _Nullable routesRsp,
                                                                   NSError * _Nullable error) {
        if (error != nil) {
            return;
        }
  
        [weakself.naviManager startNavWithIndex:0];
        //        [weakself.naviManager startWithRouteID:routesRsp.routes.firstObject.routeID];
    }];
}

#pragma mark - TNKRideNavDelegate

- (void)rideNavManagerDidStart:(TNKRideNavManager *)manager {
    
}

- (void)rideNavManagerDidStop:(TNKRideNavManager *)manager {
    
}

- (void)rideNavManager:(TNKRideNavManager *)manager didStartRerouting:(TNKRerouteReason)rerouteReason {
    
}

- (void)rideNavManager:(TNKRideNavManager *)manager updateNavigationData:(TNKRideNavigationData *)navigationData {
    
}

/**
 *  当定位发生错误时，会调用代理的此方法
 *
 *  @param manager 定位 TencentLBSLocationManager 类
 *  @param error 返回的错误，参考 TencentLBSLocationError
 */
- (void)tencentLBSLocationManager:(TencentLBSLocationManager *)manager
                 didFailWithError:(NSError *)error {
    
    NSLog(@"tencentLBSLocationManager:didFailWithError:%@", error);
}


- (void)rideNavManager:(TNKRideNavManager *)manager didUpdateLocation:(TNKLocation *)location {
      NSLog(@"RideNavController rideNavManager didUpdateLocation=%@", location);
}

/**
 *  连续定位回调函数
 *
 *  @param manager 定位 TencentLBSLocationManager 类
 *  @param location 定位结果
 */
- (void)tencentLBSLocationManager:(TencentLBSLocationManager *)manager
                didUpdateLocation:(TencentLBSLocation *)location {
    // NSLog(@"tencentLBSLocationManager didUpdateLocation=%@", location);

//    if (!self.hasFirstLocation) {
//        // 获取到的第一个定位，移动地图至当前位置
//      self.naviView.centerCoordinate = location.location.coordinate;
//      self.naviView.zoomLevel = 15;
//        self.hasFirstLocation = YES;
//        
//    }
//        
    // 记录最新50个定位点
    [self.locations addObject:location];
    if (self.locations.count > 50) {
        [self.locations removeObjectAtIndex:0];
    }
    
}


#pragma mark - TNKRideNavViewDelegate

- (void)navViewCloseButtonClicked:(TNKBaseNavView *)navView {
    [self.naviManager stopNav];
    [self.naviView clearAllRouteUI];
}
@end
