//
//  TruckRestrictionInfoViewController.m
//  NavKitDemo
//
//  Created by mol on 2023/5/24.
//

#import "TruckRestrictionInfoViewController.h"

@interface TruckRestrictionInfoViewController ()

@end

@implementation TruckRestrictionInfoViewController

- (void)viewDidLoad {
    [super viewDidLoad];
        
    [self setupBottomBar];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    [self.navigationController setToolbarHidden:NO animated:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    
    [self.navigationController setToolbarHidden:YES animated:animated];
}

#pragma mark - private

- (void)setupBottomBar {
    
    UIBarButtonItem *flexible = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace
                                                                              target:nil
                                                                              action:nil];
    
    UIBarButtonItem *planRoutesItem = [[UIBarButtonItem alloc] initWithTitle:@"1.路径规划"
                                                                       style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(planRoutes)];
    UIBarButtonItem *startNavItem = [[UIBarButtonItem alloc] initWithTitle:@"2.开启导航"
                                                                        style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(startNav)];
    self.toolbarItems = @[flexible, planRoutesItem, flexible, startNavItem, flexible];
    self.navigationController.toolbar.backgroundColor = [UIColor colorWithWhite:1 alpha:0.8];
    
}

/// 初始路径规划
- (void)planRoutes {

    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    
    // 起点使用当前定位
    TNKSearchNavPoint *origin = [[TNKSearchNavPoint alloc] init];
    TNKSearchNavPoint *destination = [[TNKSearchNavPoint alloc] init];
    
    // 交规1:
    origin.coordinate = CLLocationCoordinate2DMake(39.951172, 116.425257);
    destination.coordinate = CLLocationCoordinate2DMake(39.949241, 116.402161);
    
    // 交规2:
//    origin.coordinate = CLLocationCoordinate2DMake(39.916857,116.426539);
//    destination.coordinate = CLLocationCoordinate2DMake(39.915554, 116.429155);
    
    // 交规3: 禁止调头
//    origin.coordinate = CLLocationCoordinate2DMake(39.916857,116.426539);
//    destination.coordinate = CLLocationCoordinate2DMake(39.916416, 116.426727);
    
    // 交规4: 禁止调头
//    origin.coordinate = CLLocationCoordinate2DMake(39.907522,116.277878);
//    destination.coordinate = CLLocationCoordinate2DMake(39.907395, 116.276464);
    
    
    // 赋值
    request.origin = origin;
    request.destination = destination;
    
    // 算路策略
    TNKDriveRouteSearchOption *searchOption = [[TNKDriveRouteSearchOption alloc] init];
    searchOption.carNumber = @"桂C12345";
    // 货导参数
    TNKTruckSearchOption *truckSearchOption = [[TNKTruckSearchOption alloc] init];
    truckSearchOption.truckType = TNKTruckTypeMediumTruck;
    truckSearchOption.length = 8.0;
    truckSearchOption.width = 2.1;
    truckSearchOption.height = 4.2;
    truckSearchOption.weight = 25.0;
    truckSearchOption.load = 12.0;
    truckSearchOption.axisCount = 6;
    truckSearchOption.axisLoad = 1.0;
    truckSearchOption.plateColor = TNKTruckPlateColorBlue;
    
    searchOption.truckSearchOption = truckSearchOption;
    request.searchOption = searchOption;
    
    
    
    __weak typeof(self) weakself = self;

    // 初始路径规划
    [self.navManager searchRoutesWithRequest:request
                                  completion:^(TNKDriveRouteSearchResult * _Nullable searchResult,
                                               NSError * _Nullable error) {
       
        if (error != nil) {
            // 算路失败
            [weakself showAlertWithError:error];
            return;
        }
        
        // 清空地图上的元素
        [weakself clearRoutePlan];
        // 地图上绘制路线，并且让第一条路线高亮
        [weakself drawRoutePlan:searchResult selectedIndex:0];
    }];
}

/// 开启导航
- (void)startNav {
    // 清除导航前绘制的元素
    [self clearRoutePlan];
    
    // 展示默认导航控件
    self.navView.showUIElements = YES;
    
    self.navManager.locationSimulator.enabled = YES;
    // 使用第一条路线进行导航
    [self.navManager startNavWithIndex:0];
    
    // 隐藏toolbar
    [self.navigationController setToolbarHidden:YES animated:NO];
}

#pragma mark - TNKDriveNavDelegate
- (void)driveNavManager:(TNKDriveNavManager *)manager updateNavigationData:(TNKDriveNavigationData *)navigationData {
    
    TNKNavRestrictionInfo *navRestrictionInfo = navigationData.navRestrictionInfo;
    for (TNKTruckNavRestrictionItem *truckNavRestrictionItem in navRestrictionInfo.truckNavRestrictionItems) {
        NSLog(@"didUpdateRestrictionInfo_truck?type=%d&distance=%d&pointIndex=%d&offsetDistance=%d&coord=(%.6f,%.6f)&limitWidth=%f&limitLength=%f&limitHeight=%f&limitWeight=%f",
              truckNavRestrictionItem.truckRestrictionItem.type,
              truckNavRestrictionItem.distance,
              truckNavRestrictionItem.truckRestrictionItem.routePoint.pointIndex,
              truckNavRestrictionItem.truckRestrictionItem.routePoint.offsetDistance,
              truckNavRestrictionItem.truckRestrictionItem.routePoint.coordinate.latitude,
              truckNavRestrictionItem.truckRestrictionItem.routePoint.coordinate.longitude,
              truckNavRestrictionItem.truckRestrictionItem.limitWidth,
              truckNavRestrictionItem.truckRestrictionItem.limitLength,
              truckNavRestrictionItem.truckRestrictionItem.limitHeight,
              truckNavRestrictionItem.truckRestrictionItem.limitWeight
              );
    }
    
    for (TNKTurnNavRestrictionItem *turnNavRestrictionItem in navRestrictionInfo.turnNavRestrictionItems) {
        NSLog(@"didUpdateRestrictionInfo_turn?type=%d&distance=%d&pointIndex=%d&offsetDistance=%d&coord=(%.6f,%.6f)&limitCarType=%d&always=%d&timeDesc=%@",
              turnNavRestrictionItem.turnRestrictionItem.type,
              turnNavRestrictionItem.distance,
              turnNavRestrictionItem.turnRestrictionItem.routePoint.pointIndex,
              turnNavRestrictionItem.turnRestrictionItem.routePoint.offsetDistance,
              turnNavRestrictionItem.turnRestrictionItem.routePoint.coordinate.latitude,
              turnNavRestrictionItem.turnRestrictionItem.routePoint.coordinate.longitude,
              turnNavRestrictionItem.turnRestrictionItem.limitCarType,
              turnNavRestrictionItem.turnRestrictionItem.always,
              turnNavRestrictionItem.turnRestrictionItem.timeDesc
              );
    }
}

@end
