//
//  LandscapeModeView.h
//  NavKitDemo
//
//  Created by mol on 2023/5/19.
//

#import <UIKit/UIKit.h>
#import <TencentNavKit/TencentNavKit.h>

NS_ASSUME_NONNULL_BEGIN

@class LandscapeModeView;
@protocol LandscapeModeViewDelegate <NSObject>

- (void)landscapeModeView:(LandscapeModeView *)landscapeModeView
didClickSwitchOrientation:(UIInterfaceOrientation)deviceOrientation;

- (void)landscapeModeView:(LandscapeModeView *)landscapeModeView
    didClickSwitchNavMode:(TNKNavUIMode)navUIMode;

- (void)landscapeModeViewContinueNav:(LandscapeModeView *)landscapeModeView;

- (CGRect)enlargedMapRectForLandscapeModeView:(LandscapeModeView *)landscapeModeView;

@end

@interface LandscapeModeView : UIView <TNKDriveNavDelegate>

+ (instancetype)landscapeModeView;

@property (nonatomic, weak) id<LandscapeModeViewDelegate> delegate;

//
@property (nonatomic, readonly) UIEdgeInsets externalEdgeInsets;

/// 是否正在展示放大图
@property (nonatomic, assign) BOOL showingEnlargedMap;

/// 是否正在展示放大图
@property (nonatomic, assign) BOOL followed;

// 更新导航信息
- (void)updateNavigationData:(TNKDriveNavigationData *)navigationData;


// 切换横竖屏
- (void)switch2Orientation:(UIInterfaceOrientation)deviceOrientation;

// 切换全览、非全览模式
- (void)switch2NavMode:(TNKNavUIMode)navUIMode;

- (NSArray<id<TNKDriveNavDelegate>> *)navDelegates;

@end

NS_ASSUME_NONNULL_END
