//
//  ExtraPointForOverviewController.m
//  NaviKitDemo
//
//  Created by mol on 2022/12/23.
//

#import "ExtraPointForOverviewController.h"

@interface ExtraPointForOverviewController () <QMapViewDelegate>

@end

@implementation ExtraPointForOverviewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.navView.showUIElements = YES;
    self.navView.navUIMode = TNKNavUIModeRemainingOverview;
    self.navView.mapView.delegate = self;
    [self planRoutes];
}

- (void)planRoutes {
    
    __weak typeof(self) weakself = self;
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    TNKSearchNavPoint *origin = [[TNKSearchNavPoint alloc] init];
    origin.coordinate = CLLocationCoordinate2DMake(40.04062,116.28123);
    
    TNKSearchNavPoint *destination = [[TNKSearchNavPoint alloc] init];
    destination.coordinate = CLLocationCoordinate2DMake(40.051074,116.617126);
    
    request.origin = origin;
    request.destination = destination;
    
    TNKDriveRouteSearchOption *searchOption = [[TNKDriveRouteSearchOption alloc] init];
    request.searchOption = searchOption;
   

    [self.navManager searchRoutesWithRequest:request completion:^(TNKDriveRouteSearchResult * _Nullable searchResult, NSError * _Nullable error) {
       
        if (error != nil) {
            UIAlertAction *okAction = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            }];
            
            UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"算路失败" message:[NSString stringWithFormat:@"%d:%@", (int)error.code, error.userInfo[NSLocalizedDescriptionKey]] preferredStyle:UIAlertControllerStyleAlert];
            [alertController addAction:okAction];
            [weakself presentViewController:alertController animated:YES completion:nil];
            return;
        }
        
        [weakself startNav];
    }];
}

- (void)startNav {
    self.navManager.locationSimulator.enabled = YES;
    [self.navManager startNavWithIndex:0];
    
    TNKCoordinatePoint *extraPoint1 = [[TNKCoordinatePoint alloc] init];
    extraPoint1.coordinate = CLLocationCoordinate2DMake(39.784070, 116.394739);
    self.navView.extraPointsForOverview = @[extraPoint1];
    
    QPointAnnotation *extraMarker = [[QPointAnnotation alloc] init];
    extraMarker.coordinate = extraPoint1.coordinate;
    extraMarker.title = @"额外点";
    [self.mapView addAnnotation:extraMarker];
    
}

#pragma mark - QMapViewDelegate
- (QAnnotationView *)mapView:(QMapView *)mapView viewForAnnotation:(id<QAnnotation>)annotation {
    
    if ([annotation isKindOfClass:[QPointAnnotation class]]) {
            static NSString *annotationIdentifier = @"pointAnnotation";
            QPinAnnotationView *pinView = (QPinAnnotationView *)[self.mapView dequeueReusableAnnotationViewWithIdentifier:annotationIdentifier];
            if (pinView == nil) {
                pinView = [[QPinAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:annotationIdentifier];
                pinView.canShowCallout = YES;
                pinView.pinColor = QPinAnnotationColorRed;
            }
            
            return pinView;
        }
        
        return nil;
}


@end
