//
//  EnlargedMapController.m
//  NaviKitDemo
//
//  Created by mol on 2022/12/26.
//

#import "EnlargedMapCaseController.h"

@interface EnlargedMapCaseController ()

@end

@implementation EnlargedMapCaseController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.navView.navigationPanelEnabled = NO;
    self.navView.guidedLaneEnabled = NO;
    [self planRoutes];
}

- (void)planRoutes {
    
    __weak typeof(self) weakself = self;
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    TNKSearchNavPoint *origin = [[TNKSearchNavPoint alloc] init];
//    origin.coordinate = CLLocationCoordinate2DMake(40.038591, 116.273023);
    origin.coordinate = CLLocationCoordinate2DMake(40.019333, 116.283964);
    TNKSearchNavPoint *destination = [[TNKSearchNavPoint alloc] init];
    destination.coordinate = CLLocationCoordinate2DMake(40.051074, 116.617126);
    
    request.origin = origin;
    request.destination = destination;
    
    TNKDriveRouteSearchOption *searchOption = [[TNKDriveRouteSearchOption alloc] init];
    request.searchOption = searchOption;
   

    [self.navManager searchRoutesWithRequest:request completion:^(TNKDriveRouteSearchResult * _Nullable searchResult, NSError * _Nullable error) {
       
        if (error != nil) {
            UIAlertAction *okAction = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            }];
            
            UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"算路失败" message:[NSString stringWithFormat:@"%d:%@", (int)error.code, error.userInfo[NSLocalizedDescriptionKey]] preferredStyle:UIAlertControllerStyleAlert];
            [alertController addAction:okAction];
            [weakself presentViewController:alertController animated:YES completion:nil];
            return;
        }
        
        [weakself startNav];
    }];
}

- (void)startNav {
    self.navManager.locationSimulator.enabled = YES;
    [self.navManager startNavWithIndex:0];
    TNKEnlargedMapConfig *enlargedMapConfig = self.navView.enlargedMapConfig;
    enlargedMapConfig.enlargedMapRect = CGRectMake(40, 80, 200, 100);
    enlargedMapConfig.showEnlargedMapProgressView = NO;
    enlargedMapConfig.topLeftCornerRadius = 10;
    enlargedMapConfig.topRightCornerRadius = 10;
    enlargedMapConfig.bottomLeftCornerRadius = 20;
    enlargedMapConfig.bottomRightCornerRadius = 20;
    [self.navView updateEnlargedMapConfig:enlargedMapConfig];
}

#pragma mark - TNKDriveNavViewDelegate
- (void)navViewDidShowEnlargedMap:(TNKDriveNavView *)navView {
    
    TNKEnlargedMapConfig *enlargedMapConfig = self.navView.enlargedMapConfig;
    enlargedMapConfig.enlargedMapRect = CGRectMake(40 + (rand() % 2 ? 100 : 0), 80 + (rand() % 2 ? 50 : 0), 200, 100);
    enlargedMapConfig.showEnlargedMapProgressView = rand() % 2;
    enlargedMapConfig.topLeftCornerRadius = 10;
    enlargedMapConfig.topRightCornerRadius = 10;
    enlargedMapConfig.bottomLeftCornerRadius = 20 + rand() % 10;
    enlargedMapConfig.bottomRightCornerRadius = 20 + rand() % 10;
    [self.navView updateEnlargedMapConfig:enlargedMapConfig];
}


@end
