//
//  DriveSimlulationController.m
//  NavKitDemo
//
//  Created by mol on 2023/2/8.
//

#import "DriveSimlulationCaseController.h"

@interface DriveSimlulationCaseController ()

@end

@implementation DriveSimlulationCaseController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // 发起算路
    [self planRoutes];
}

/// 初始路径规划
- (void)planRoutes {
    
    __weak typeof(self) weakself = self;
    
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    
    // 起点信息
    TNKSearchNavPoint *origin = [[TNKSearchNavPoint alloc] init];
    origin.coordinate = CLLocationCoordinate2DMake(40.038591, 116.273023);
    
    // 终点信息. 可以使用关键词检索获得坐标、poi id、名称等信息。
    // 详情见: https://lbs.qq.com/service/webService/webServiceGuide/webServiceSuggestion
    TNKSearchNavPoint *destination = [[TNKSearchNavPoint alloc] init];
    destination.coordinate = CLLocationCoordinate2DMake(39.907773, 116.401273);
    destination.poiID = @"2199027907804";
    destination.title = @"天安门东[地铁站]";
    
    // 赋值
    request.origin = origin;
    request.destination = destination;
    
    // 算路策略
    TNKDriveRouteSearchOption *searchOption = [[TNKDriveRouteSearchOption alloc] init];
    // 导航场景. 1表示去接乘客, 2表示去送乘客. 默认值为0.
    searchOption.navScene = 1;
    request.searchOption = searchOption;

    // 初始路径规划
    [self.navManager searchRoutesWithRequest:request
                                  completion:^(TNKDriveRouteSearchResult * _Nullable searchResult,
                                               NSError * _Nullable error) {
       
        if (error != nil) {
            // 算路失败
            [weakself showAlertWithError:error];
            return;
        }
        
        // 算路成功，开始模拟导航
        [weakself startNav];
    }];
}

- (void)startNav {
    // 展示默认导航控件
    self.navView.showUIElements = YES;
    // 使用第一条路线进行模拟导航
    self.navManager.locationSimulator.enabled = YES;
    [self.navManager startNavWithIndex:0];
}

@end
