//
//  DriveLocationReplayViewController.m
//  NavKitDemo
//
//  Created by mol on 2023/2/1.
//

#import "DriveLocationReplayViewController.h"
#import <TencentNavKit/TencentNavKit.h>
#import <QMapKit/QMapKit.h>

@interface DriveLocationReplayViewController ()

@end

@implementation DriveLocationReplayViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.navView.showUIElements = YES;
    
    [self planRoutes];
}

- (void)planRoutes {
    
    __weak typeof(self) weakself = self;
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    TNKSearchNavPoint *origin = [[TNKSearchNavPoint alloc] init];
    origin.coordinate = CLLocationCoordinate2DMake(39.983707,116.30821);
    
    TNKSearchNavPoint *destination = [[TNKSearchNavPoint alloc] init];
    destination.coordinate = CLLocationCoordinate2DMake(39.896835,116.319423);
    
    request.origin = origin;
    request.destination = destination;
    
    TNKDriveRouteSearchOption *searchOption = [[TNKDriveRouteSearchOption alloc] init];
    request.searchOption = searchOption;

    
    [self.navManager searchRoutesWithRequest:request completion:^(TNKDriveRouteSearchResult * _Nullable searchResult, NSError * _Nullable error) {
       
        if (error != nil) {
            UIAlertAction *okAction = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            }];
            
            UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"算路失败" message:[NSString stringWithFormat:@"%d:%@", (int)error.code, error.userInfo[NSLocalizedDescriptionKey]] preferredStyle:UIAlertControllerStyleAlert];
            [alertController addAction:okAction];
            [weakself presentViewController:alertController animated:YES completion:nil];
            return;
        }
        
        [weakself startNavWithRouteID:searchResult.routes.firstObject.routeID];
    
    }];
}

- (void)startNavWithRouteID:(NSString *)routeID {
    // performance.gps
    NSString *filePath = [[NSBundle mainBundle] pathForResource:@"case001" ofType:@"gps"];

    self.navManager.locationSimulator.enabled = YES;
    self.navManager.locationSimulator.simulateLocationsType = TNKSimulateLocationsTypeReplay;
    self.navManager.locationSimulator.filePath = filePath;
    [self.navManager startNavWithIndex:0];
}

@end
