//
//  WaypointController.m
//  NaviKitDemo
//
//  Created by mol on 2022/12/23.
//

#import "DriveCustomWaypointMarkerCaseController.h"


@interface DriveCustomWaypointMarkerCaseController ()

@end

@implementation DriveCustomWaypointMarkerCaseController

#pragma mark - lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self setupBottomBar];

    self.navView.navUIMode = TNKNavUIModeRemainingOverview;
}


- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    [self.navigationController setToolbarHidden:NO animated:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    
    [self.navigationController setToolbarHidden:YES animated:animated];
}


#pragma mark - private

- (void)setupBottomBar {
    
    UIBarButtonItem *flexible = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace
                                                                              target:nil
                                                                              action:nil];
    
    UIBarButtonItem *configItem = [[UIBarButtonItem alloc] initWithTitle:@"自定义样式"
                                                                       style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(configCustomMarkers)];
    UIBarButtonItem *hideItem = [[UIBarButtonItem alloc] initWithTitle:@"隐藏途经点"
                                                                       style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(hideMarkes)];
    
    UIBarButtonItem *startNavItem = [[UIBarButtonItem alloc] initWithTitle:@"开启导航"
                                                                        style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(planRoutes)];
        
    
    
    self.toolbarItems = @[flexible, configItem, flexible, hideItem, flexible, startNavItem, flexible];
    self.navigationController.toolbar.backgroundColor = [UIColor colorWithWhite:1 alpha:0.8];
}

- (void)planRoutes {
    
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    TNKSearchNavPoint *origin = [[TNKSearchNavPoint alloc] init];
    origin.coordinate = CLLocationCoordinate2DMake(40.04062,116.28123);
    
    TNKSearchNavPoint *destination = [[TNKSearchNavPoint alloc] init];
    destination.coordinate = CLLocationCoordinate2DMake(40.051074,116.617126);
    
    request.origin = origin;
    request.destination = destination;
    
    TNKDriveRouteSearchOption *searchOption = [[TNKDriveRouteSearchOption alloc] init];
    request.searchOption = searchOption;
    
    TNKSearchNavPoint *waypoint1 = [[TNKSearchNavPoint alloc] init];
    waypoint1.coordinate = CLLocationCoordinate2DMake(39.968150,116.320667);
    waypoint1.searchUID = @"1";
    TNKSearchNavPoint *waypoint2 = [[TNKSearchNavPoint alloc] init];
    waypoint2.coordinate = CLLocationCoordinate2DMake(39.988235,116.426309);
    waypoint2.searchUID = @"2";

    request.waypoints = @[waypoint1,waypoint2];
    
    __weak typeof(self) weakself = self;

    [self.navManager searchRoutesWithRequest:request completion:^(TNKDriveRouteSearchResult * _Nullable searchResult, NSError * _Nullable error) {
       
        if (error != nil) {
            [self showAlertWithError:error];
            return;
        }
        
        [weakself startNav];
        
    }];
}

- (void)startNav {
    self.navManager.locationSimulator.enabled = YES;
    [self.navManager startNavWithIndex:0];}

- (void)configCustomMarkers {
    
    TNKWaypointMarkerPresentation *waypointConfig1 = [[TNKWaypointMarkerPresentation alloc] init];
    waypointConfig1.bubbleImage = [UIImage imageNamed:@"passby_m01"];
    TNKWaypointMarkerPresentation *waypointConfig2 = [[TNKWaypointMarkerPresentation alloc] init];
    waypointConfig2.bubbleImage = [UIImage imageNamed:@"passby_m02"];
    NSMutableDictionary<NSString *, TNKWaypointMarkerPresentation *> *waypointMarkerPresentationDict = [NSMutableDictionary dictionary];
    waypointMarkerPresentationDict[@"1"] = waypointConfig1;
    waypointMarkerPresentationDict[@"2"] = waypointConfig2;
    [self.navView updateWaypointMarkerPresentation:waypointMarkerPresentationDict];
}

- (void)hideMarkes {
    TNKWaypointMarkerPresentation *waypointConfig1 = [[TNKWaypointMarkerPresentation alloc] init];
    TNKWaypointMarkerPresentation *waypointConfig2 = [[TNKWaypointMarkerPresentation alloc] init];
    NSMutableDictionary<NSString *, TNKWaypointMarkerPresentation *> *waypointMarkerPresentationDict = [NSMutableDictionary dictionary];
    waypointMarkerPresentationDict[@"1"] = waypointConfig1;
    waypointMarkerPresentationDict[@"2"] = waypointConfig2;
    [self.navView updateWaypointMarkerPresentation:waypointMarkerPresentationDict];
}


@end
