//
//  DriveCustomRouteConfigCaseController.m
//  NavKitDemo
//
//  Created by mol on 2023/2/10.
//

#import "DriveCustomRouteConfigCaseController.h"

@interface DriveCustomRouteConfigCaseController ()

@end

@implementation DriveCustomRouteConfigCaseController

#pragma mark - lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self setupBottomBar];
    self.navView.navUIMode = TNKNavUIModeRemainingOverview;
}


- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    [self.navigationController setToolbarHidden:NO animated:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    
    [self.navigationController setToolbarHidden:YES animated:animated];
}


#pragma mark - private

- (void)setupBottomBar {
    
    UIBarButtonItem *flexible = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace
                                                                              target:nil
                                                                              action:nil];
    
    UIBarButtonItem *configItem = [[UIBarButtonItem alloc] initWithTitle:@"自定义样式"
                                                                       style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(configCustom)];
    UIBarButtonItem *hideItem = [[UIBarButtonItem alloc] initWithTitle:@"切换日夜间模式"
                                                                       style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(switchDayNightMode)];
    
    UIBarButtonItem *startNavItem = [[UIBarButtonItem alloc] initWithTitle:@"开启导航"
                                                                        style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(planRoutes)];
        
    
    
    self.toolbarItems = @[flexible, configItem, flexible, hideItem, flexible, startNavItem, flexible];
    self.navigationController.toolbar.backgroundColor = [UIColor colorWithWhite:1 alpha:0.8];
}

- (void)planRoutes {
    
    __weak typeof(self) weakself = self;
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    TNKSearchNavPoint *origin = [[TNKSearchNavPoint alloc] init];
    origin.coordinate = CLLocationCoordinate2DMake(40.04062,116.28123);
    
    TNKSearchNavPoint *destination = [[TNKSearchNavPoint alloc] init];
    destination.coordinate = CLLocationCoordinate2DMake(40.051074,116.617126);
    
    request.origin = origin;
    request.destination = destination;
    
    TNKDriveRouteSearchOption *searchOption = [[TNKDriveRouteSearchOption alloc] init];
    request.searchOption = searchOption;
  
    [self.navManager searchRoutesWithRequest:request completion:^(TNKDriveRouteSearchResult * _Nullable searchResult, NSError * _Nullable error) {
       
        if (error != nil) {
            [self showAlertWithError:error];
            return;
        }
        
        [weakself startNav];
        
    }];
}

- (void)startNav {
    self.navManager.locationSimulator.enabled = YES;
    [self.navManager startNavWithIndex:0];
    
}

- (void)configCustom {
    
    // 日夜间样式，填充和描边颜色互换
    TNKRouteColorPalette *mainDayFillColorPalette = [[TNKRouteColorPalette alloc] initWithSmoothColor:[UIColor greenColor]
                                                                                        slowColor:[UIColor yellowColor]
                                                                                    verySlowColor:[UIColor orangeColor]
                                                                                         jamColor:[UIColor redColor]
                                                                                       eraseColor:[UIColor blackColor]
                                                                                     unknownColor:[UIColor blueColor]];
    TNKRouteColorPalette *mainDayBorderColorPalette = [[TNKRouteColorPalette alloc] initWithSmoothColor:[UIColor systemGreenColor]
                                                                                        slowColor:[UIColor systemYellowColor]
                                                                                    verySlowColor:[UIColor systemOrangeColor]
                                                                                         jamColor:[UIColor systemRedColor]
                                                                                       eraseColor:[UIColor grayColor]
                                                                                     unknownColor:[UIColor systemBlueColor]];
    
    TNKRouteColorPalette *mainNightFillColorPalette = [[TNKRouteColorPalette alloc] initWithSmoothColor:[UIColor systemGreenColor]
                                                                                        slowColor:[UIColor systemYellowColor]
                                                                                    verySlowColor:[UIColor systemOrangeColor]
                                                                                         jamColor:[UIColor systemRedColor]
                                                                                       eraseColor:[UIColor grayColor]
                                                                                     unknownColor:[UIColor systemBlueColor]];
    
    TNKRouteColorPalette *mainNightBorderColorPalette = [[TNKRouteColorPalette alloc] initWithSmoothColor:[UIColor greenColor]
                                                                                        slowColor:[UIColor yellowColor]
                                                                                    verySlowColor:[UIColor orangeColor]
                                                                                         jamColor:[UIColor redColor]
                                                                                       eraseColor:[UIColor blackColor]
                                                                                     unknownColor:[UIColor blueColor]];
    
    
    // 伴随路线的配置
    TNKRouteColorPalette *backupDayFillColorPalette = [[TNKRouteColorPalette alloc] initWithSmoothColor:[UIColor cyanColor]
                                                                                        slowColor:[UIColor magentaColor]
                                                                                    verySlowColor:[UIColor purpleColor]
                                                                                         jamColor:[UIColor brownColor]
                                                                                       eraseColor:[UIColor darkGrayColor]
                                                                                     unknownColor:[UIColor blueColor]];
    
    TNKRouteColorPalette *backupDayBorderColorPalette = [[TNKRouteColorPalette alloc] initWithSmoothColor:[UIColor systemGrayColor]
                                                                                        slowColor:[UIColor systemPinkColor]
                                                                                    verySlowColor:[UIColor systemPurpleColor]
                                                                                         jamColor:[UIColor systemTealColor]
                                                                                       eraseColor:[UIColor grayColor]
                                                                                     unknownColor:[UIColor systemBlueColor]];
    
    
    
    TNKRouteColorPalette *backupNightFillColorPalette = [[TNKRouteColorPalette alloc] initWithSmoothColor:[UIColor systemGrayColor]
                                                                                        slowColor:[UIColor systemPinkColor]
                                                                                    verySlowColor:[UIColor systemPurpleColor]
                                                                                         jamColor:[UIColor systemTealColor]
                                                                                       eraseColor:[UIColor grayColor]
                                                                                     unknownColor:[UIColor systemBlueColor]];
    
    TNKRouteColorPalette *backupNightBorderColorPalette = [[TNKRouteColorPalette alloc] initWithSmoothColor:[UIColor cyanColor]
                                                                                        slowColor:[UIColor magentaColor]
                                                                                    verySlowColor:[UIColor purpleColor]
                                                                                         jamColor:[UIColor brownColor]
                                                                                       eraseColor:[UIColor darkGrayColor]
                                                                                     unknownColor:[UIColor blueColor]];

    TNKRouteLineConfig *mainRouteLineConfig = [[TNKRouteLineConfig alloc] initWithDayFillColorPalette:mainDayFillColorPalette
                                                                                dayStrokeColorPalette:mainDayBorderColorPalette
                                                                                nightFillColorPalette:mainNightFillColorPalette
                                                                              nightStrokeColorPalette:mainNightBorderColorPalette];
    mainRouteLineConfig.width = 16;
    TNKRouteLineConfig *backupRouteLineConfig = [[TNKRouteLineConfig alloc] initWithDayFillColorPalette:backupDayFillColorPalette
                                                                                dayStrokeColorPalette:backupDayBorderColorPalette
                                                                                nightFillColorPalette:backupNightFillColorPalette
                                                                              nightStrokeColorPalette:backupNightBorderColorPalette];
    backupRouteLineConfig.width = 16;

    TNKRouteConfig *routeConfig = [[TNKRouteConfig alloc] initWithMainRouteColorConfig:mainRouteLineConfig accompanyRouteColorConfig:backupRouteLineConfig];
    routeConfig.flowArrowGap = 50;
    
    [self.navView updateRouteConfig:routeConfig];
}

- (void)switchDayNightMode {
    
    // 切换日夜间模式，方便查看自车标变化
    if (self.navView.dayNightStatus == TNKNavDayNightStatusDay) {
        self.navView.dayNightMode = TNKNavDayNightModeAlwaysNight;
    } else {
        self.navView.dayNightMode = TNKNavDayNightModeAlwaysDay;
    }
}
@end
