//
//  DriveCustomPanel.m
//  NavKitDemo
//
//  Created by mol on 2023/2/8.
//

#import "DriveCustomPanel.h"

@interface DriveCustomPanel ()

@property (weak, nonatomic) IBOutlet UIImageView *turnImageView;

@property (nonatomic, weak) IBOutlet UILabel *distanceLabel;
@property (nonatomic, weak) IBOutlet UILabel *distanceUnitLabel;
@property (nonatomic, weak) IBOutlet UILabel *actionLabel;
@property (nonatomic, weak) IBOutlet UILabel *roadNameLabel;
@property (weak, nonatomic) IBOutlet UILabel *passedDistanceLabel;
@property (weak, nonatomic) IBOutlet UILabel *passedTimeLabel;

@end

@implementation DriveCustomPanel

+ (instancetype)CustomPanel {
    
    DriveCustomPanel * driveCustomPanel = [[UINib nibWithNibName:@"DriveCustomPanelView" bundle:nil] instantiateWithOwner:nil options:nil].firstObject;
    return driveCustomPanel;
}

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    
    return self;
}

- (instancetype)initWithCoder:(NSCoder *)coder {
    self = [super initWithCoder:coder];
    if (self) {
        [self setup];
    }
    
    return self;
}

- (void)setup {

}

- (void)updateNavigationData:(TNKDriveNavigationData *)navigationData {
    self.turnImageView.image = navigationData.intersectionImage;
    self.roadNameLabel.text = navigationData.nextRoadName;
    
    if (navigationData.nextDistanceLeft > 1000) {
        // 大于一公里，单位展示为公里
        self.distanceLabel.text = [NSString stringWithFormat:@"%.1f", navigationData.nextDistanceLeft / 1000.0];
        self.distanceUnitLabel.text = @"公里";
    } else if (navigationData.nextDistanceLeft > 10) {
        // 大于十米，单位展示为米
        self.distanceLabel.text = [NSString stringWithFormat:@"%d", navigationData.nextDistanceLeft];
        self.distanceUnitLabel.text = @"米";
    } else {
        // 展示为 "现在"
        self.distanceLabel.text = @"现在";
        self.distanceUnitLabel.text = @"";
    }
    
    
    if (navigationData.passedDistance > 1000) {
        // 大于一公里，单位展示为公里
        self.passedDistanceLabel.text = [NSString stringWithFormat:@"%.1f公里", navigationData.passedDistance / 1000.0];
    } else {
        self.passedDistanceLabel.text = [NSString stringWithFormat:@"%d米", navigationData.passedDistance];
    }
    
    NSMutableString *passedTimeText = [NSMutableString string];
    if (navigationData.passedTime > 60 * 60) {
        // 大于1小时
        [passedTimeText appendFormat:@"%d小时", navigationData.passedTime / 3600];
    }
    
    int fraction = ceil((navigationData.passedTime % 3600) / 60.0);
    [passedTimeText appendFormat:@"%d分", MAX(1, fraction)];
    self.passedTimeLabel.text = passedTimeText;
}

@end
