//
//  ODMarkerConfigController.m
//  NaviKitDemo
//
//  Created by mol on 2022/12/21.
//

#import "DriveCustomODMarkerController.h"


@interface DriveCustomODMarkerController ()

@end

@implementation DriveCustomODMarkerController

#pragma mark - lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self setupBottomBar];
    

    self.navView.navUIMode = TNKNavUIModeRemainingOverview;    
}


- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    [self.navigationController setToolbarHidden:NO animated:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    
    [self.navigationController setToolbarHidden:YES animated:animated];
}


#pragma mark - private

- (void)setupBottomBar {
    
    UIBarButtonItem *flexible = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace
                                                                              target:nil
                                                                              action:nil];
    
    UIBarButtonItem *configItem = [[UIBarButtonItem alloc] initWithTitle:@"自定义样式"
                                                                       style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(configCustomMarkers)];
    UIBarButtonItem *hideItem = [[UIBarButtonItem alloc] initWithTitle:@"隐藏起终点"
                                                                       style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(hideMarkes)];
    
    UIBarButtonItem *startNavItem = [[UIBarButtonItem alloc] initWithTitle:@"开启导航"
                                                                        style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(planRoutes)];
        
    
    
    self.toolbarItems = @[flexible, configItem, flexible, hideItem, flexible, startNavItem, flexible];
    self.navigationController.toolbar.backgroundColor = [UIColor colorWithWhite:1 alpha:0.8];
}

- (void)planRoutes {
    
    __weak typeof(self) weakself = self;
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    TNKSearchNavPoint *origin = [[TNKSearchNavPoint alloc] init];
    origin.coordinate = CLLocationCoordinate2DMake(40.04062,116.28123);
    
    TNKSearchNavPoint *destination = [[TNKSearchNavPoint alloc] init];
    destination.coordinate = CLLocationCoordinate2DMake(40.051074,116.617126);
    
    request.origin = origin;
    request.destination = destination;
    
    TNKDriveRouteSearchOption *searchOption = [[TNKDriveRouteSearchOption alloc] init];
    request.searchOption = searchOption;
  
    [self.navManager searchRoutesWithRequest:request completion:^(TNKDriveRouteSearchResult * _Nullable searchResult, NSError * _Nullable error) {
       
        if (error != nil) {
            [self showAlertWithError:error];
            return;
        }
        
        [weakself startNav];
        
    }];
}

- (void)startNav {
    self.navManager.locationSimulator.enabled = YES;
    [self.navManager startNavWithIndex:0];
}

- (void)configCustomMarkers {
    
    // 自定义起点
    TNKODMarkerPresentation *originPresentation = [[TNKODMarkerPresentation alloc] init];
    originPresentation.bubbleImage = [UIImage imageNamed:@"custom_origin_marker"];
    originPresentation.circleImage = [UIImage imageNamed:@"custom_destination_circle"];
    [self.navView updateOriginMarkerPresentation:originPresentation];
    
    // 自定义终点
    TNKODMarkerPresentation *destPresentation = [[TNKODMarkerPresentation alloc] init];
    destPresentation.bubbleImage = [UIImage imageNamed:@"custom_destination_marker"];
    destPresentation.circleImage = [UIImage imageNamed:@"custom_origin_circle"];
    [self.navView updateDestinationMarkerPresentation:destPresentation];
}

- (void)hideMarkes {
    TNKODMarkerPresentation *originPresentation = [[TNKODMarkerPresentation alloc] init];
    [self.navView updateOriginMarkerPresentation:originPresentation];
    
    TNKODMarkerPresentation *destPresentation = [[TNKODMarkerPresentation alloc] init];
    [self.navView updateDestinationMarkerPresentation:destPresentation];
}

@end
