//
//  BaseCaseController.h
//  NaviKitDemo
//
//  Created by mol on 2022/12/16.
//

#import <UIKit/UIKit.h>
#import <QMapKit/QMapView.h>
#import <TencentNavKit/TencentNavKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface DriveBaseCaseController : UIViewController<QMapViewDelegate, TNKDriveNavDelegate, TNKDriveNavViewDelegate>

/// 导航管理类
@property (nonatomic, readonly) TNKDriveNavManager *navManager;

/// 导航地图
@property (nonatomic, readonly) TNKDriveNavView *navView;

/// 获取地图实例
- (QMapView *)mapView;

/// 清除路线
- (void)clearRoutePlan;
/// 将路线展示在地图可视区域上
- (void)adjustRoutesFitMap;


/// 根据路径规划结果画线
/// - Parameters:
///   - routesRsp: 导航算路结果
///   - selectedIndex: 第几条路线高亮
- (void)drawRoutePlan:(TNKDriveRouteSearchResult *)routesRsp selectedIndex:(NSInteger)selectedIndex;

///  展示alert
/// - Parameter error: 错误信息
- (void)showAlertWithError:(NSError *)error;

@end

NS_ASSUME_NONNULL_END
