//
//  LimitAreaController.m
//  NaviKitDemo
//
//  Created by mol on 2022/12/16.
//

#import "DriveAvoidAreaController.h"

@interface DriveAvoidAreaController ()

@property (nonatomic, strong) NSMutableArray<QPolygon *> *avoidAreaPolygons;

@end

@implementation DriveAvoidAreaController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.avoidAreaPolygons = [NSMutableArray array];
    
    [self planRoutes];
}


#pragma mark - private

- (void)planRoutes {
    __weak typeof(self) weakself = self;
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    TNKSearchNavPoint *origin = [[TNKSearchNavPoint alloc] init];
    origin.coordinate = CLLocationCoordinate2DMake(40.041382, 116.270671);
    
    TNKSearchNavPoint *destination = [[TNKSearchNavPoint alloc] init];
    destination.coordinate = CLLocationCoordinate2DMake(40.042220, 116.276722);
    
    request.origin = origin;
    request.destination = destination;
    
    NSArray<TNKCoordinatePoint *> *avoidArea = [self avoidAreasCase1];
    
    NSArray<NSArray<TNKCoordinatePoint *> *> *avoidAreas = @[avoidArea];
    [request setAvoidAreas:avoidAreas];
    
    [self.navManager searchRoutesWithRequest:request
                                  completion:^(TNKDriveRouteSearchResult * _Nullable searchResult,
                                                                  NSError * _Nullable error) {
        __strong DriveAvoidAreaController *strongself = weakself;
        if (error != nil) {
            
            [strongself showAlertWithError:error];
            return;
        }
        
        [strongself clearRoutePlan];
        [strongself drawRoutePlan:searchResult selectedIndex:0 avoidAreas:avoidAreas];
    }];
}

- (void)clearRoutePlan {
    [super clearRoutePlan];
    
    [self.mapView removeOverlays:self.avoidAreaPolygons];
    [self.avoidAreaPolygons removeAllObjects];
}

- (void)drawRoutePlan:(TNKDriveRouteSearchResult *)routesRsp
        selectedIndex:(NSInteger)selectedIndex
           avoidAreas:(NSArray<NSArray<TNKCoordinatePoint *> *> *)avoidAreas {
    
    [self drawRoutePlan:routesRsp selectedIndex:selectedIndex];
    
   
    for (int i = 0; i < avoidAreas.count; i++) {
        NSArray<TNKCoordinatePoint *> *avoidArea = avoidAreas[i];
        
        CLLocationCoordinate2D coordinates[avoidArea.count];
        
        for (int j = 0; j < avoidArea.count; j++) {
            coordinates[j].latitude = avoidArea[j].coordinate.latitude;
            coordinates[j].longitude = avoidArea[j].coordinate.longitude;
        }

        QPolygon *polygon = [QPolygon polygonWithCoordinates:coordinates count:avoidArea.count];
        [self.avoidAreaPolygons addObject:polygon];
        [self.mapView addOverlay:polygon];
    }
}



- (NSArray<TNKCoordinatePoint *> *)avoidAreasCase1 {
    TNKCoordinatePoint *point1 = [[TNKCoordinatePoint alloc] init];
    point1.coordinate = CLLocationCoordinate2DMake(40.041456, 116.271771);
    
    TNKCoordinatePoint *point2 = [[TNKCoordinatePoint alloc] init];
    point2.coordinate = CLLocationCoordinate2DMake(40.041813, 116.274651);
    
    TNKCoordinatePoint *point3 = [[TNKCoordinatePoint alloc] init];
    point3.coordinate = CLLocationCoordinate2DMake(40.042158, 116.274635);
    
    TNKCoordinatePoint *point4 = [[TNKCoordinatePoint alloc] init];
    point4.coordinate = CLLocationCoordinate2DMake(40.041756, 116.271615);
    
    return @[point1, point2, point3, point4];
}


@end
