//
//  DismissUIWhenNavigatingController.m
//  NaviKitDemo
//
//  Created by mol on 2022/12/26.
//

#import "DismissUIWhenNavigatingController.h"

@interface DismissUIWhenNavigatingController ()

@end

@implementation DismissUIWhenNavigatingController

#pragma mark - lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.


    [self setupBottomBar];
    
    // 如果需要，设置我的位置的图片
    QUserLocationPresentation *userLocationPresentation = [[QUserLocationPresentation alloc] init];
    userLocationPresentation.icon = [UIImage imageNamed:@"car_icon_day"];
    [self.navView configureUserLocationPresentation:userLocationPresentation];
    self.navView.showsUserLocation = YES;

}


- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    [self.navigationController setToolbarHidden:NO animated:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    
    [self.navigationController setToolbarHidden:YES animated:animated];
}


#pragma mark - private

- (void)setupBottomBar {
    
    UIBarButtonItem *flexible = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace
                                                                              target:nil
                                                                              action:nil];
    
    UIBarButtonItem *startNavItem = [[UIBarButtonItem alloc] initWithTitle:@"开启导航"
                                                                        style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(planRoutes)];

    UIBarButtonItem *hideItem = [[UIBarButtonItem alloc] initWithTitle:@"导航中隐藏"
                                                                       style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(hideElements)];
    UIBarButtonItem *showItem = [[UIBarButtonItem alloc] initWithTitle:@"导航中展示"
                                                                       style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(showElements)];
    
    
    UIBarButtonItem *stopNavItem = [[UIBarButtonItem alloc] initWithTitle:@"结束导航"
                                                                    style:UIBarButtonItemStyleDone
                                                                   target:self
                                                                   action:@selector(stopNav)];


    
    self.toolbarItems = @[flexible, startNavItem, flexible, hideItem, flexible, showItem, flexible, stopNavItem, flexible];
    self.navigationController.toolbar.backgroundColor = [UIColor colorWithWhite:1 alpha:0.8];
}

- (void)planRoutes {
    
    __weak typeof(self) weakself = self;
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    TNKSearchNavPoint *origin = [[TNKSearchNavPoint alloc] init];
    origin.coordinate = CLLocationCoordinate2DMake(40.04062,116.28123);
    
    TNKSearchNavPoint *destination = [[TNKSearchNavPoint alloc] init];
    destination.coordinate = CLLocationCoordinate2DMake(40.051074,116.617126);
    
    request.origin = origin;
    request.destination = destination;
    
    TNKDriveRouteSearchOption *searchOption = [[TNKDriveRouteSearchOption alloc] init];
    request.searchOption = searchOption;
  
    [self.navManager searchRoutesWithRequest:request completion:^(TNKDriveRouteSearchResult * _Nullable searchResult, NSError * _Nullable error) {
       
        if (error != nil) {
            [self showAlertWithError:error];
            return;
        }
        
        [weakself startNav];
        
    }];
}

- (void)startNav {
    self.navManager.locationSimulator.enabled = YES;
    [self.navManager startNavWithIndex:0];}

- (void)hideElements {
    
    // 路线宽度设置为0,即可隐藏路线
    TNKRouteConfig *routeConfig = self.navView.routeConfig;
    routeConfig.mainRouteColorConfig.width = 0;
    routeConfig.accompanyRouteColorConfig.width = 0;
    [self.navView updateRouteConfig:routeConfig];
    
    // 隐藏路线上的红绿灯
    self.navView.routeTrafficLightHidden = YES;
    // 隐藏导航面板
    self.navView.navigationPanelEnabled = NO;
    // 隐藏车道线
    self.navView.guidedLaneEnabled = NO;
    // 隐藏路线上的电子眼
    self.navView.cameraMarkerEnabled = NO;
    // 隐藏放大图
    TNKEnlargedMapConfig *enlargedMapConfig = self.navView.enlargedMapConfig;
    enlargedMapConfig.enlargedMapEnabled = NO;
    [self.navView updateEnlargedMapConfig:enlargedMapConfig];
    // 隐藏自车点上的罗盘
    self.navView.compassHidden = YES;
    // 隐藏路线上的转向箭头
    self.navView.turnArrowEnabled = NO;
    // 隐藏路线上的拥堵气泡
    self.navView.trafficBubbleEnabled = NO;
    // 隐藏伴随路线上的气泡
    self.navView.backupRouteBubbleHidden = YES;
}

- (void)showElements {
    
    // 恢复路线宽度
    TNKRouteConfig *routeConfig = self.navView.routeConfig;
    routeConfig.mainRouteColorConfig.width = 14;
    routeConfig.accompanyRouteColorConfig.width = 14;
    [self.navView updateRouteConfig:routeConfig];
    
    self.navView.routeTrafficLightHidden = NO;
    self.navView.navigationPanelEnabled = YES;
    self.navView.guidedLaneEnabled = YES;
    self.navView.cameraMarkerEnabled = YES;
    TNKEnlargedMapConfig *enlargedMapConfig = self.navView.enlargedMapConfig;
    enlargedMapConfig.enlargedMapEnabled = YES;
    [self.navView updateEnlargedMapConfig:enlargedMapConfig];
    self.navView.compassHidden = NO;
    self.navView.turnArrowEnabled = YES;
    self.navView.trafficBubbleEnabled = YES;
    self.navView.backupRouteBubbleHidden = NO;
}

- (void)stopNav {
    [self.navManager stopNav];
    [self.navView clearAllRouteUI];
    
}



@end
