//
//  CustomTurnArrowController.m
//  NavKitDemo
//
//  Created by mol on 2023/3/24.
//

#import "CustomTurnArrowController.h"

@interface CustomTurnArrowController ()

@end

@implementation CustomTurnArrowController

#pragma mark - lifecycle

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self setupBottomBar];
}


- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    [self.navigationController setToolbarHidden:NO animated:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    
    [self.navigationController setToolbarHidden:YES animated:animated];
}


#pragma mark - private

- (void)setupBottomBar {
    
    UIBarButtonItem *flexible = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace
                                                                              target:nil
                                                                              action:nil];
    
    UIBarButtonItem *configItem = [[UIBarButtonItem alloc] initWithTitle:@"自定义样式"
                                                                       style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(configCustom)];
   
    UIBarButtonItem *startNavItem = [[UIBarButtonItem alloc] initWithTitle:@"开启导航"
                                                                        style:UIBarButtonItemStyleDone
                                                                       target:self
                                                                       action:@selector(planRoutes)];
        
    
    
    self.toolbarItems = @[flexible, configItem, flexible, startNavItem, flexible];
    self.navigationController.toolbar.backgroundColor = [UIColor colorWithWhite:1 alpha:0.8];
}

- (void)planRoutes {
    
    __weak typeof(self) weakself = self;
    TNKDriveRouteRequest *request = [[TNKDriveRouteRequest alloc] init];
    TNKSearchNavPoint *origin = [[TNKSearchNavPoint alloc] init];
    origin.coordinate = CLLocationCoordinate2DMake(40.04062,116.28123);
    
    TNKSearchNavPoint *destination = [[TNKSearchNavPoint alloc] init];
    destination.coordinate = CLLocationCoordinate2DMake(40.051074,116.617126);
    
    request.origin = origin;
    request.destination = destination;
    
    TNKDriveRouteSearchOption *searchOption = [[TNKDriveRouteSearchOption alloc] init];
    request.searchOption = searchOption;
  
    [self.navManager searchRoutesWithRequest:request completion:^(TNKDriveRouteSearchResult * _Nullable searchResult, NSError * _Nullable error) {
       
        if (error != nil) {
            [self showAlertWithError:error];
            return;
        }
        
        [weakself startNav];
        
    }];
}

- (void)startNav {
    self.navManager.locationSimulator.enabled = YES;
    [self.navManager startNavWithIndex:0];
    
}

- (void)configCustom {
    
    TNKTurnArrowConfig *arrowConfig = self.navView.turnArrowConfig;
    arrowConfig.arrowColor = [UIColor blackColor];
    self.navView.turnArrowConfig = arrowConfig;
}


@end
