//
//  AppDelegate.m
//  TencentNavSDKDemo
//
//  Created by mol on 2023/2/17.
//

#import "AppDelegate.h"
#import <TencentNavKit/TencentNavKit.h>
#import <QMapKit/QMapKit.h>
#import "DeviceUtil.h"

@interface AppDelegate ()

@end

@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    
    // 获取Key的方式 https://lbs.qq.com/mobile/iOSNaviSDK/naviGuide/getAuth
    NSString *mapKey = @"";
    NSString *navKey = @"";
    [[QMapServices sharedServices] setPrivacyAgreement:YES];
    assert(mapKey.length > 0);
    [[QMapServices sharedServices] setAPIKey:mapKey];
    
    [[TNKNavServices sharedServices] setPrivacyAgreement:YES];
    assert(navKey.length > 0);
    [[TNKNavServices sharedServices] setKey:navKey];
    
    NSLog(@"float f %@", [[TNKNavServices sharedServices] sdkVersion]);
    
    [self.window makeKeyAndVisible];


    return YES;
}

- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(UIWindow *)window {
    switch (DeviceUtil.currentOrientation) {
        case UIInterfaceOrientationPortrait:
            return UIInterfaceOrientationMaskPortrait;
            break;
        case UIInterfaceOrientationPortraitUpsideDown:
            return UIInterfaceOrientationMaskPortraitUpsideDown;
            break;
        case UIInterfaceOrientationLandscapeRight:
            return UIInterfaceOrientationMaskLandscapeRight;
            break;
        case UIInterfaceOrientationLandscapeLeft:
            return UIInterfaceOrientationMaskLandscapeLeft;
            break;
        default:
            break;
    }
    return UIInterfaceOrientationMaskPortrait;
}

@end
