## 导航SDK v6.9.0（2024-05-15）
### 更新说明

1. 导航路径规划长距离支持分片。
```c++
驾车路径规划算路策略新增参数sliceType，可指定分包分片的详细类型；
@property (nonatomic, assign) TNKSliceType sliceType;

typedef enum _TNKSliceType
{
    TNKSliceTypeNone    = 0,        ///< 不分片
    TNKSliceTypeTwo     = 1,        ///< 两段
    TNKSliceTypeThree   = 2,        ///< 三段
    TNKSliceTypeAuto    = 9,        ///< 自动
} TNKSliceType;         ///< 分包分片的详细类型

TNKDriveNavDelegate新增回调方法
/**
 * @brief slice状态下导航开启的回调，根据success自行处理后续的逻辑，如失败重新算路等;如三段slice的情况下自行在success的情况下发起导航
 * @param nav_session_id session id
 * @param success 成功或者失败
 */
- (void)driveNavManagerOnNavigationDataReady:(TNKDriveNavManager *)manager
                          nav_session_id:(NSString *)nav_session_id
                                 success:(BOOL)success;

```

2. TTS播报可以控制语音播报速度

```c++
TNKAudioPlayer新增播放速度控制参数及方法：
/**
 *  @brief 控制语音播报速度，请在开始播报之前设置完成设置范围[20, 100],默认是50是正常速度（不设置该属性默认也是正常速度），最大支持100是双倍速度
 *  @since 6.9.0
 */
@property (nonatomic, assign) int rate;

/**
 * @brief 播放速度设置。传入其他无效类型不生效 since 6.9.0
 * @param type 播报速度类型
 */
- (void)playWithRate:(TNKAudioPlayRateType)type;

使用示例
[TNKAudioPlayer sharedAudioPlayer].rate = 60;
[[TNKAudioPlayer sharedAudioPlayer] playWithRate:TNKAudioPlayRateSlow];
```
3. 包体积优化。
4. 鉴权错误上报和导航状态上报优化。
5. 已知问题修复。


### 安装

```c++
/**
 * CocoaPods
 */
pod 'TencentNavKit', '6.9.0'

/**
 * 手动下载framework包地址
 * @url https://framework-70105.njc.vod.tencent-cloud.com/nav/TencentNavKit_6.9.0.zip
 */
```
