## 导航SDK v6.8.3（2024-03-25）

1. 导航定位支持巡航功能。
TNKLocationAdapter新增方法，可以开启巡航模式，获得巡航定位信息。

```
/// 添加定位监听
- (void)addLocationListener:(id<TencentLBSLocationManagerDelegate>)delegate;

/// 移除定位监听
- (void)removeLocationListener:(id<TencentLBSLocationManagerDelegate>)delegate;

/// 添加定位监听
- (void)addLocationListener:(id<TencentLBSLocationManagerDelegate>)delegate 
              lisenerConfig:(TNKLocationListenerConfig * _Nullable)lisenerConfig;

typedef enum : NSInteger {
    TNKLocationListenerConfigTypeNormal = 0,    ///< 普通定位
    TNKLocationListenerConfigTypeCruise = 1,    ///< 巡航定位
} TNKLocationListenerConfigType;
```

开发者监听者需要实现如下协议
```
@protocol TNKPosMatchLocationListener <TencentLBSLocationManagerDelegate>

/**
 *  当定位发生错误时，会调用代理的此方法
 *
 *  @param manager 定位 TencentLBSLocationManager 类
 *  @param PosMatchLocation 吸附定位信息
 */
- (void)tencentLBSLocationManager:(TencentLBSLocationManager *)manager
                 didUpdatePosMatchLocation:(TNKPosMatchLocation *)PosMatchLocation;

@end

/**
 * @brief 巡航道路吸附信息
 */
@interface TNKNavRoadMatchResult : NSObject

/**
 * @brief 巡航道路吸附状态
 */
@property (nonatomic, readonly) TNKRoadMatchStatus roadMatchStatus;

/**
 * @brief 吸附坐标
 */
@property (nonatomic, readonly) CLLocation *mactchLocation;

/**
 * @brief 道路等级
 */
@property (nonatomic, readonly) TNKRoadGrade roadGrade;

/**
 * @brief 道路属性
 */
@property (nonatomic, readonly) TNKRoadKind roadKind;

/**
 * @brief 道路方向[0,360), 获取不到时为-1
 */
@property (nonatomic, readonly) double roadDir;

@end

/**
 * @brief 巡航定位信息
 */
@interface TNKPosMatchLocation: NSObject

/**
 * @brief 原始定位
 */
@property (nonatomic, readonly) TencentLBSLocation *origLocation;

/**
 * @brief 巡航道路吸附信息
 */
@property (nonatomic, readonly) TNKNavRoadMatchResult *roadMatchResult;

@end

typedef enum _TNKRoadMatchStatus
{
    TNKRoadMatchStatusNull = -1,            ///< 默认值
    TNKRoadMatchStatusOffRoute = 0,         ///< 车标脱离
    TNKRoadMatchStatusOnRoute = 1,          ///< 车标匹配在路上
} TNKRoadMatchStatus;   ///< 道路吸附结果
```
2. 导航地图新增离线地图接口。
3. 更新定位SDK，优化定位卡顿。
4. 已知问题修复。


### 安装

```c++
/**
 * CocoaPods
 */
pod 'TencentNavKit', '6.8.3'

/**
 * 手动下载framework包地址
 * @url https://framework-70105.njc.vod.tencent-cloud.com/nav/TencentNavKit_6.8.3.zip
 */
```
