## 导航 SDK v6.7.5（2024-01-26）

1. 新增配置算路结果缓存数量。
2. 新增开启导航失败回调。
3. 优化了导航素材体积。

### 安装

```c++
/**
 * CocoaPods
 */
pod 'TencentNavKit', '6.7.5'

/**
 * framework下载包地址
 * @url https://framework-70105.njc.vod.tencent-cloud.com/nav/TencentNavKit_6.7.5.zip
 */
```

### 导航接口变更

1. 设置保留算路结果缓存数量

```c++
TNKDriveNavManager对象方法
/**
 * @brief 设置路径规划缓存数 [1, 8]，默认 1.
 * @since 6.7.5
 * @param number 个数.
 * @return 是否成功
 */
- (BOOL)setNaveRoutePlanCacheSize:(int) routePlanCacheSize;

```

2. 增加开启导航失败回调

```c++
/**
 * @brief 导航开始失败回调.
 * @param manager manager
 * @param startFailInfo 导航开始失败回调内容
 */
- (void)driveNavManager:(TNKDriveNavManager *)manager didStartNavFail:(TNKNavStartFailInfo *)startFailInfo;


使用示例：
- (void)driveNavManager:(TNKDriveNavManager *)manager didStartNavFail:(TNKNavStartFailInfo*)startFailInfo {
    NSLog(@"didStartNavFail?isRunning=%@", startFailInfo.msg);
}

```
