## 导航SDK v6.2.0-alpha.1（2023-04-28）

- TNKDriveNavigationData新增字段如下，

```
/**
 * @brief 本次导航已行驶时间，单位：秒
 */
@property (nonatomic, readonly) int passedTime;

/**
 * @brief 本次导航已行驶里程，单位：米
 */
@property (nonatomic, readonly) int passedDistance;
```

- TNKSegmentItem下的TNKSegmentRoadName新增如下字段，

```
/**
 * @brief 道路行政等级
 */
@property (nonatomic, readonly) TNKRoadGrade grade;

/**
 * @brief 道路属性
 */
@property (nonatomic, readonly) TNKRoadKind roadKind;

/**
 * @brief 长度.单位，米
 */
@property (nonatomic, readonly) int length;
```


- TNKDriveNavView新增trafficBar,

```
/**
 *  @brief 是否显示路况光柱图，默认NO
 */
@property (nonatomic, assign) BOOL showTrafficBar;

/**
 *  @brief 光柱图实例，当showTrafficBar为YES时才不为空
 */
@property (nonatomic, readonly, nullable) TNKNaviTrafficBarWidget *trafficBar;
```

- TNKSegmentItem新增adcode字段

- TNKDriveRouteSearchOption新增字段，

```
/**
 * @brief 是否规避限行。默认为YES
 * @since 6.2.0
 */
@property (nonatomic, assign) BOOL avoidLimit;
```

- TNKTruckSearchOption新增字段，

```
/**
 * @brief 算路时是否忽略重量。默认为NO
 */
@property (nonatomic, assign) BOOL willIgnoreWeight;
```

- 路线变更回调的TNKChangeRouteMsg新增reason，为TNKChangeRouteMsgReasonReroute，定义如下

```
/// 主路线变化的原因
typedef enum _TNKChangeRouteMsgReason
{
    TNKChangeRouteMsgReasonUnkown           = 0,    ///< 未知
    TNKChangeRouteMsgReasonClicking         = 1,    ///< 司机点击备选路线
    TNKChangeRouteMsgReasonDrivingIn        = 2,    ///< 司机驶入备选路线
    TNKChangeRouteMsgReasonByAPI            = 3,    ///< 开发者调用API切换路线
    TNKChangeRouteMsgReasonRoadClosed       = 4,    ///< 封路导致切换路线
    TNKChangeRouteMsgReasonLimitChanged     = 5,    ///< 交限变化导致切换路线
    TNKChangeRouteMsgReasonReroute          = 6,    ///< 重新算路导致的路线变化
} TNKChangeRouteMsgReason;
```

- TNKDriveNavDelegate新增回调，

```
/**
 * @brief 前方电子眼信息，会给出一定距离内的电子眼信息。size为0时表示前方一定距离内没有电子眼
 * @param manager manager
 * @param navCameras 电子眼信息数组
 */
- (void)driveNavManager:(TNKDriveNavManager *)manager didUpdateCameraInfo:(NSArray<TNKNavCameraInfo *> *)navCameras;
```