## 导航SDK v6.1.0-alpha.1（2023-03-24）

-  货导算路参数TNKTruckSearchOption升级，

```
/**
 * @brief 货车导航算路参数.
 * @since 5.2.1
 */
@interface TNKTruckSearchOption : NSObject<NSCopying>

/**
 * @brief 货车类型， 默认为轻型车
 */
@property (nonatomic, assign) TNKTruckType truckType;

/**
 * @brief 长度，单位：m
 */
@property (nonatomic, assign) float length;

/**
 * @brief 宽度，单位：m
 */
@property (nonatomic, assign) float width;

/**
 * @brief 高度，单位：m
 */
@property (nonatomic, assign) float height;

/**
 * @brief 总重量，单位：吨
 */
@property (nonatomic, assign) float weight;

/**
 * @brief 核定载重,单位：吨
 */
@property (nonatomic, assign) float load;

/**
 * @brief 轴数
 */
@property (nonatomic, assign) int axisCount;

/**
 * @brief 轴重,单位：吨
 */
@property (nonatomic, assign) float axisLoad;

/**
 * @brief 拖车类型
 */
@property (nonatomic, assign) TNKTruckTrailerType trailerType;

/**
 * @brief 车牌颜色。
 */
@property (nonatomic, assign) TNKTruckPlateColor plateColor;

/**
 * @brief 能源类型
 */
@property (nonatomic, assign) TNKEnergyType energyType;

/**
 * @brief 功能类型
 */
@property (nonatomic, assign) TNKTruckFunctionType functionType;

/**
 * @brief 尾气排放标准
 */
@property (nonatomic, assign) TNKEmissionStandard emissionStandard;

/**
 * @brief 通行证类型
 */
@property (nonatomic, assign) TNKTruckPassType passType;

@end
```


- TNKDriveNaView新增turnArrowConfig属性，可修改转向箭头样式，

```
/**
 *  @brief 设置是转向箭头的样式，不可为nil
 */
@property (nonatomic, strong) TNKTurnArrowConfig *turnArrowConfig;

```

```
/// 是否隐藏路线上的转向箭头，默认为NO
@property (nonatomic, assign) BOOL hidden;
/// 箭头颜色
@property (nonatomic, strong) UIColor *arrowColor;
/// 描边颜色
@property (nonatomic, strong) UIColor *borderColor;
/// 阴影颜色
@property (nonatomic, strong) UIColor *shadowColor;
// 是否为3D箭头，默认为YES
@property (nonatomic, assign) BOOL is3D;
// 箭头宽度与路线宽度的比值，默认为1
@property (nonatomic, assign) CGFloat widthScale;

@end
```

- TNKDriveNavDelegate新增前方拥堵信息回调,

```
/**
 * @brief 前方拥堵区域信息的更新回调。
 * @param manager manager
 * @param trafficJamInfo 前方拥堵区域信息。为nil时代表拥堵消失
 */
- (void)driveNavManager:(TNKDriveNavManager *)manager didUpdateTrafficJamInfo:(TNKTrafficJamInfo * _Nullable)trafficJamInfo;
```
