//
//  QDotScatterOverlay.h
//  QMapKit
//
//  Created by Keith Cao on 2021/4/28.
//  Copyright © 2021 tencent. All rights reserved.
//

#import <QMapKit/QGLOverlay.h>
#import <QMapKit/QHeatNodeProtocol.h>
#import "QScatterNodeProtocol.h"

NS_ASSUME_NONNULL_BEGIN

/**
 *  @brief 点散点overlay类型, 搭配QDotScatterOverlayView使用
 */
@interface QDotScatterOverlay : QGLOverlay

/**
 *  @brief  散点图数据: 原始的节点数据. 数组每个元素符合 QScatterNodeProtocol 协议
 *
 */
@property (nonatomic, copy) NSArray <id <QScatterNodeProtocol> > *nodes;

/**
 *  @brief 散点颜色数据, 散点颜色于 QScatterNodeProtocol 中的type成映射关系
 */
@property (nonatomic, strong) NSArray <UIColor *> *colors;

/**
 *  @brief 散点半径 单位: point 默认 2
 */
@property (nonatomic, assign) double radius;

/**
 *  @brief 是否开启3D效果. 默认为NO
 */
@property (nonatomic, assign) BOOL enable3D;

/**
 *  @brief 是否动画辐射效果
 */
@property (nonatomic, assign) BOOL animated;

@end

NS_ASSUME_NONNULL_END
