//
//  QMaskingLayer.h
//  QMapKit
//
//  Created by halldwang on 2025/8/21.
//  Copyright © 2025 tencent. All rights reserved.
//

#import "QMaskingLayerOutlineArea.h"

NS_ASSUME_NONNULL_BEGIN
/**
 *  @brief 地图蒙层覆盖物
 */
@interface QMaskingLayer : NSObject

/**
 * @brief 设置蒙层颜色, 默认纯白色
 * @note  当gradient 为true时，蒙层颜色展示不支持alpha通道; 当gradient 为false时, 蒙层颜色展示支持alpha通道
 */
@property (nonatomic, strong) UIColor* maskingColor;

/**
 * 设置蒙层边缘是否渐变, 默认YES
 */
@property (nonatomic, assign) BOOL gradient;

/**
 * 非蒙层区域的轮廓数组，元素为QMaskingLayerOutlineArea类
 */
@property (nonatomic, strong) NSArray <QMaskingLayerOutlineArea*> *areaOutlines;

@end

NS_ASSUME_NONNULL_END
