//
//  QMarkerViewDefines.h
//  QMapKit
//
//  Created by KeithCao on 2024/5/28.
//  Copyright © 2024 tencent. All rights reserved.
//

#ifndef QMarkerViewDefines_h
#define QMarkerViewDefines_h

#import <Foundation/Foundation.h>

/**
 * @enum QMarkerViewDragState
 *  QMarkerView的拖拽状态
 */
typedef enum {
    QMarkerViewDragStateNone = 0,      ///< 静止状态.
    QMarkerViewDragStateStarting,      ///< 开始拖动
    QMarkerViewDragStateDragging,      ///< 拖动中
    QMarkerViewDragStateCanceling,     ///< 取消拖动
    QMarkerViewDragStateEnding         ///< 拖动结束
} QMarkerViewDragState;

/**
 * @brief QMarkerViewCollisionType
 *  QMarkerView的碰撞类型
 */
typedef NS_OPTIONS(NSUInteger,  QMarkerViewCollisionType){
    QMarkerViewCollisionTypeCollisionTypeNone  = 0,        /// 不发生碰撞
    QMarkerViewCollisionTypeWithLabel = 1 << 0,           /// 可以与地图POI元素碰撞
    QMarkerViewCollisionTypeWithQMarkerView = 1 << 1     ///可以和Marker碰撞
};

#endif /* QMarkerViewDefines_h */
