//
//  QMarker.h
//  QMapKit
//
//  Created by Keith Cao on 2020/1/19.
//  Copyright © 2020 tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import <UIKit/UIKit.h>
#import "QShape.h"
#import "QOverlay.h"
#import "QTypes.h"

NS_ASSUME_NONNULL_BEGIN

/**
 *  @brief  标记覆盖物.
 *
 * 此类用于定义一个标记点
 */
@interface QMarker : QShape <QOverlay>

/**
 * @brief  区域外接矩形
 */
@property(nonatomic, readonly) QMapRect boundingMapRect;

/// 初始化QMarker
/// @param coordinate 经纬度
- (instancetype)initWithCoordinate:(CLLocationCoordinate2D)coordinate;

/**
 *	@brief marker 的经纬度坐标
 */
@property (nonatomic, assign, readonly) CLLocationCoordinate2D coordinate;


@end

NS_ASSUME_NONNULL_END
