//
//  QAnnotationView+Collision.h
//  QMapKit
//
//  Created by Keith Cao on 2023/11/21.
//  Copyright © 2023 tencent. All rights reserved.
//

#import <QMapKit/QMapKit.h>
#import "QAnnotationView.h"

NS_ASSUME_NONNULL_BEGIN

@interface QAnnotationView (Collision)

/**
 *	@brief	添加碰撞子Marker，添加的元素需遵循QAnnotationViewCollisionDelegate协议
 *	@note	1. QAnnotationView及其子类类型的不能作为子Marker元素添加
 *			2. 通过接口添加后，若从AnnotationView上移除，需调用removeQAnnotationViewCollisionChild接口，否则碰撞表现异常
 *			3. 碰撞优先级跟随AnnotationView的zIndex
 *	@return 添加是否成功（添加不遵循QAnnotationViewCollisionDelegate协议的类或QAnnotationView类及其子类会返回失败）
 */
- (BOOL)addQAnnotationViewCollisionChild:(UIView <QAnnotationViewCollisionDelegate> *)childView;

/**
 *	@brief	移除碰撞子marker，元素需遵循QAnnotationViewCollisionDelegate协议
 *	@note	接口调用不会调用removeFromSuperview，只移除碰撞功能
 *	@return	是否成功移除（移除不遵循QAnnotationViewCollisionDelegate协议的类或QAnnotationView类及其子类会返回失败）
 */
- (BOOL)removeQAnnotationViewCollisionChild:(UIView <QAnnotationViewCollisionDelegate> *)childView;

/**
 *	@brief	更新子Marker碰撞，元素需遵循QAnnotationViewCollisionDelegate协议
 *	@note	如更新大小，碰撞类型等，需要调用此接口
 */
- (void)updateQAnnotationViewCollisionChild:(UIView <QAnnotationViewCollisionDelegate> *)childView;

/**
 *	@brief	设置碰撞主marker的数据来源
 *	@param	mainView  数据来源
 *	@note	1.设置mainView后，该View无法作为子Marker添加
 *			2. 已添加的子Marker无法设置为mainView
 *			3. QAnnotationView类无法设置为数据来源
 *			4. 传入 nil，恢复使用QAnnotationView本身作为主marker的数据来源
 *          5. 碰撞类型使用QAnnotationView自身
 *          6. mainView的旋转anchorPoint需和经纬度位置一致，否则碰撞区域不准确
 */
- (void)setQAnnotationViewCollisionMainView:(UIView * _Nullable)mainView;

@end

NS_ASSUME_NONNULL_END
