//
//  StyleView.m
//  QMapKitDebugging
//
//  Created by Zhang Tian on 2018/8/17.
//  Copyright © 2018年 Tencent. All rights reserved.
//

#import "StyleView.h"

@interface StyleView ()
{
    UILabel *_titleLabel;
    UILabel *_styleLabel;
}

@end

@implementation StyleView

#pragma mark - Setup

- (void)setupSelf
{
    self.backgroundColor = [UIColor groupTableViewBackgroundColor];
}

- (void)setupViews
{
    _titleLabel = [[UILabel alloc] init];
    _titleLabel.text = @"自定义地图样式:";
    _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    
    _styleLabel = [[UILabel alloc] init];
    _styleLabel.text = @"当前显示的地图样式为样式一";
    _styleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    
    [self addSubview:_titleLabel];
    [self addSubview:_styleLabel];
}

- (void)setupConstraints
{
    [_titleLabel.leadingAnchor constraintEqualToAnchor:self.leadingAnchor constant:10].active = YES;
    [_titleLabel.topAnchor constraintEqualToAnchor:self.topAnchor constant:10].active = YES;
    
    [_styleLabel.centerXAnchor constraintEqualToAnchor:self.centerXAnchor].active = YES;
    [_styleLabel.topAnchor constraintEqualToAnchor:_titleLabel.bottomAnchor constant:20].active = YES;
}

#pragma mark - Property

- (void)setStyleString:(NSString *)styleString
{
    _styleString = styleString;
    _styleLabel.text = styleString;
}

#pragma mark - Life Cycle

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    [self setupSelf];
    [self setupViews];
    [self setupConstraints];
    
    return self;
}

@end
