//
//  OfflineDownloadCell.h
//  QMapKitDemo
//
//  Created by v_hefang on 2020/5/29.
//  Copyright © 2020 tencent. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <QMapKit/QMapKit.h>

NS_ASSUME_NONNULL_BEGIN

@class OfflineDownloadCell;

@protocol OfflineDownloadCellDelegate <NSObject>

- (void)offlineDownloadCell:(OfflineDownloadCell *)cell downloadWithItem:(QOfflineItem *)item;
- (void)offlineDownloadCell:(OfflineDownloadCell *)cell cancelDownloadWithItem:(QOfflineItem *)item;
- (void)offlineDownloadCell:(OfflineDownloadCell *)cell deleteWithItem:(QOfflineItem *)item;

@end

@interface OfflineDownloadCell : UITableViewCell

@property (nonatomic, strong) QOfflineItem *item;

@property (nonatomic, weak) id<OfflineDownloadCellDelegate> delegate;

- (void)updateDownloadStatus:(QOfflineItemDownloadStatus)status;

@end

NS_ASSUME_NONNULL_END
