//
//  Heat3DViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2021/4/28.
//  Copyright © 2021 tencent. All rights reserved.
//

#import "Heat3DViewController.h"

#import <QMapVisualPlugin/QMapPluginKit.h>

#import "StyleView.h"

#define GlobalNavAndStatusHight (self.navigationController.navigationBar.frame.size.height + [[UIApplication sharedApplication] statusBarFrame].size.height)

static const NSInteger GlobalStyleTitleArrayCount = 13;

static NSString *const GlobalStyleTitleArray[GlobalStyleTitleArrayCount] =
{
	@"展示层级和颜色",
	@"半径",
	@"级别+类型",
	@"透明度",
	@"可见性",
	@"3D",
	@"热力区间",
	@"高度",
	@"zIndex",
	@"配色一",
	@"配色二",
	@"配色三",
	@"配色四"
};



@interface Heat3DViewController ()

@property (nonatomic, strong) QHeatOverlay *heatOverlay;

@property (nonatomic, strong) QHeatOverlay *heat2;

@property (nonatomic, strong) StyleView *styleView;

@end

@implementation Heat3DViewController

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QHeatOverlay class]]) {
		QHeatOverlayView *hv = [[QHeatOverlayView alloc] initWithOverlay:overlay];
		// 设置在POI之上
		hv.displayLevel = QOverlayLevelAboveLabels;
		return hv;
	}
	
	return nil;
}

- (void)viewDidLoad
{
	[super viewDidLoad];
	
	[self setupSelf];
	[self setupNavigation];
	self.mapView.delegate = self;
	self.mapView.showsScale = YES;
	self.mapView.overlooking = 40;
	self.mapView.zoomLevel = 8;
	self.mapView.centerCoordinate = CLLocationCoordinate2DMake(39.91718071931067,116.4151898097858);
	
	self.mapView.mapType = QMapTypeDark;
}


- (void)handleTestAction
{
	[self addHeat];
}

- (void)handleTest2Action
{
	[self.mapView removeOverlays:self.mapView.overlays];
	
}

- (void)addHeat
{
	NSString *filePath = [[NSBundle mainBundle] pathForResource:@"heatTest_2" ofType:@"heat"];
	NSString* fileContents = [NSString stringWithContentsOfFile:filePath encoding:NSUTF8StringEncoding error:nil];

	NSArray* allLinedStrings = [fileContents componentsSeparatedByCharactersInSet:[NSCharacterSet newlineCharacterSet]];
	
	NSMutableArray <QHeatNode *> *nodes = [NSMutableArray array];
	
	[allLinedStrings enumerateObjectsUsingBlock:^(NSString *  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
		
		NSArray *ar = [obj componentsSeparatedByCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
		if(ar.count == 3 ){
			// 纬度.
			double lat = [ar[1] doubleValue];
			// 经度.
			double lon = [ar[0] doubleValue];
			// 权值.
			double val = [ar[2] doubleValue];
			
			QHeatNode *node = [[QHeatNode alloc] init];
			node.coordinate = CLLocationCoordinate2DMake(lat, lon);
			node.value      = val;
			
			[nodes addObject:node];
		}
	}];
	
	self.heatOverlay = [[QHeatOverlay alloc] initWithHeatNodes:nodes];
	
	// 默认初始化热力图渐变属性会使用默认配色方案
	QHeatGradient *grad = [[QHeatGradient alloc] init];
	// 也可以根据自定义配色方案生成热力图渐变属性
//	QHeatGradient *gradient = [[QHeatGradient alloc] initWithColor:@[[UIColor blueColor], [UIColor greenColor],[UIColor redColor]] andWithStartPoints:@[@(0.2), @(0.5),@(0.9)]];
//	self.heatOverlay.gradient = gradient
	self.heatOverlay.gradient = grad;
	
	// 调整热力的最大高度
	self.heatOverlay.maxHeight = 50;
	
	// 调整热力的衰退半径
	self.heatOverlay.decayRadius = 20;
	
	// 通用动画类
	QAnimation *animation = [[QAnimation alloc] init];
	animation.duration = 3;
	
	// 设置生成热力图时的动画
	self.heatOverlay.animation = animation;
	
	// 是否开启3D效果
	self.heatOverlay.enable3D = YES;
	
	// 将热力图添加到地图上，配合mapView:viewForOverlay:回调使用
	[self.mapView addOverlay:self.heatOverlay];
}

#pragma mark - Setup

- (void)setupSelf
{
	self.view.backgroundColor = [UIColor groupTableViewBackgroundColor];
}

- (void)setupNavigation
{
	
	UIBarButtonItem *switchButton = [[UIBarButtonItem alloc] initWithTitle:@"切换样式" style:UIBarButtonItemStyleDone target:self action:@selector(handleSwitchAction)];
	UIBarButtonItem *remove = [[UIBarButtonItem alloc] initWithTitle:@"删除"  style:UIBarButtonItemStyleDone  target:self action:@selector(handleTest2Action)];
	
	self.navigationItem.rightBarButtonItems = [self.navigationItem.rightBarButtonItems arrayByAddingObject:remove];
	
	self.navigationItem.rightBarButtonItems = [self.navigationItem.rightBarButtonItems arrayByAddingObject:switchButton];
}


#pragma mark - Action

- (void)handleSwitchAction
{
	UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"请选择需要切换的样式" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
	
	[alertController addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil]];
	
	for (int i = 0; i < GlobalStyleTitleArrayCount; i++)
	{
		[alertController addAction:[UIAlertAction actionWithTitle:GlobalStyleTitleArray[i] style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
			[self handleChangeAction:i];
		}]];
	}
	
	[self presentViewController:alertController animated:YES completion:nil];
}


#pragma mark -- changeAction

- (void)handleChangeAction:(NSInteger)actNum
{
	switch (actNum) {
		case 0:
			
			[self changeColorAndDisplayLevel];
			
			break;
		case 1:
			[self changeSize];
			
			break;
			
		case 2:
			[self changeZoomAndType];
			
			break;
		case 3:
			[self changeOpacity];
			break;
			
		case 4:
			[self changeVisible];
			break;
		case 5:
			[self change3D];
			break;
		case 6:
			[self changeIntensity];
			break;
		case 7:
			[self changeHeight];
			break;
		case 8:
			[self changeZIndex];
			break;
		case 9:
			[self changeColorStyle];
			break;
		case 10:
			[self changeColorStyleTwo];
			break;
		case 11:
			[self changeColorStyleThree];
			break;
		case 12:
			[self changeColorStyleFour];
			break;
		default:
			break;
	}
}

// 颜色+展示层级
- (void)changeColorAndDisplayLevel
{
	NSArray<UIColor *> *colorDB = @[
		[UIColor purpleColor],
		[UIColor cyanColor],
		[UIColor greenColor]
	];
	QHeatGradient *gradient = [[QHeatGradient alloc] initWithColor:colorDB andWithStartPoints:@[@0.0f,@0.5f, @1.f]];
	self.heatOverlay.gradient = gradient;
	
	[self.heatOverlay setNeedsDisplay];
	
	QHeatOverlayView *hv = (QHeatOverlayView *) [self.mapView viewForOverlay:self.heatOverlay];
	
	hv.displayLevel = QOverlayLevelAboveBuildings;
}

// 1 半径
- (void)changeSize
{
	int radius = arc4random() % 47;
	
	self.heatOverlay.decayRadius = radius;
	[self.heatOverlay setNeedsDisplay];
}

// 2 type 和 最大最小
- (void)changeZoomAndType
{
	[self.heatOverlay setMinZoomLevel:10 maxZoomLevel:16];
	
	[self.heatOverlay setNeedsDisplay];
}

// 3 透明
- (void)changeOpacity
{
	self.heatOverlay.opacity = self.heatOverlay.opacity == 1 ? 0.5 : 1;
}

// 4 可见性
- (void)changeVisible
{
	self.heatOverlay.visible = !self.heatOverlay.visible;
}

//5 3d
- (void)change3D
{
	self.heatOverlay.enable3D = !self.heatOverlay.enable3D;
	[self.heatOverlay setNeedsDisplay];
}

// 6 热力区间
- (void)changeIntensity
{
	int i = arc4random() % 100;
	[self.heatOverlay setMinIntensity:i/3 maxIntensity:i];
	[self.heatOverlay setNeedsDisplay];
}

// 7 高度
- (void)changeHeight
{
	int height = arc4random() % 59;
	height += 15;
	[self.heatOverlay setMaxHeight:height];
	[self.heatOverlay setNeedsDisplay];
}

// 8 zindex
- (void)changeZIndex
{
	
	self.heat2 = [[QHeatOverlay alloc] initWithHeatNodes:self.heatOverlay.nodes];
	[self.mapView addOverlay:self.heat2];
	
	__weak __typeof(self) ws = self;
	dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
		QHeatOverlayView *hv = (QHeatOverlayView *)[ws.mapView viewForOverlay:ws.heatOverlay];
		QHeatOverlayView *hv2 = (QHeatOverlayView *)[ws.mapView viewForOverlay:ws.heat2];
		NSLog(@"heat :%d,  heat2:%d", hv.zIndex, hv2.zIndex);
		hv.zIndex = 100;
		NSLog(@"heat :%d,  heat2:%d", hv.zIndex, hv2.zIndex);
		
		dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
			[ws.mapView removeOverlay:ws.heat2];
		});
	});
	
	
}

// 9 配色1
- (void)changeColorStyle
{
	self.mapView.mapType = QMapTypeDark;
	self.mapView.overlooking = 40;
	
	if (self.heatOverlay)
	{
		NSArray *styleColors =  @[
			[UIColor colorWithRed:77 / 255.0 green:111 / 255.0 blue:255 / 255.0 alpha:1.0],
			[UIColor colorWithRed:0 / 255.0 green:238 / 255.0 blue:227 / 255.0 alpha:1.0],
			[UIColor colorWithRed:113 / 255.0 green:236 / 255.0 blue:80 / 255.0 alpha:1.0],
			[UIColor colorWithRed:255 / 255.0 green:176 / 255.0 blue:0 / 255.0 alpha:1.0],
			[UIColor colorWithRed:255 / 255.0 green:72 / 255.0 blue:0 / 255.0 alpha:1.0]
		];
		
		NSArray *startPoints = @[@0.1f, @0.185f, @0.3571f, @0.6142f, @1.f
		];
		
		QHeatGradient *grad = [[QHeatGradient alloc] initWithColor:styleColors andWithStartPoints:startPoints];
		
		self.heatOverlay.enable3D = YES;
		self.heatOverlay.gradient = grad;
		
		[self.heatOverlay setNeedsDisplay];
		
	}
}

// 10 配色2
- (void)changeColorStyleTwo
{
	self.mapView.mapType = QMapTypeDark;
	self.mapView.overlooking = 40;
	
	if (self.heatOverlay)
	{
		NSArray *styleColors =  @[
			[UIColor colorWithRed:0x20 / 255.0 green:0x19 / 255.0 blue:0x34 / 255.0 alpha:1.0],
			[UIColor colorWithRed:0x00 / 255.0 green:0x34 / 255.0 blue:0x5C / 255.0 alpha:1.0],
			[UIColor colorWithRed:0x00 / 255.0 green:0x66 / 255.0 blue:0x44 / 255.0 alpha:1.0],
			[UIColor colorWithRed:0x5D / 255.0 green:0xA0 / 255.0 blue:0x0D/ 255.0 alpha:1.0],
			[UIColor colorWithRed:0xFF / 255.0 green:0xC8 / 255.0 blue:0x00 / 255.0 alpha:1.0]
		];
		
		NSArray *startPoints = @[@0.1f, @0.1959f, @0.5163f, @0.9265f, @1.f
		];
		
		QHeatGradient *grad = [[QHeatGradient alloc] initWithColor:styleColors andWithStartPoints:startPoints];
		
		self.heatOverlay.enable3D = YES;
		self.heatOverlay.gradient = grad;
		
		[self.heatOverlay setNeedsDisplay];
		
	}
}

// 11 配色3
- (void)changeColorStyleThree
{
	self.mapView.mapType = QMapTypeDark;
	self.mapView.overlooking = 40;
	
	if (self.heatOverlay)
	{
		NSArray *styleColors =  @[
			[UIColor colorWithRed:0x00 / 255.0 green:0x36 / 255.0 blue:0x74 / 255.0 alpha:1.0],
			[UIColor colorWithRed:0x5B / 255.0 green:0xBF / 255.0 blue:0xF9 / 255.0 alpha:1.0],
			[UIColor colorWithRed:0xFF / 255.0 green:0xFF / 255.0 blue:0xFF / 255.0 alpha:1.0],
			[UIColor colorWithRed:0xDE / 255.0 green:0x56 / 255.0 blue:0x1C / 255.0 alpha:1.0],
			[UIColor colorWithRed:0xCA / 255.0 green:0x00 / 255.0 blue:0x26 / 255.0 alpha:1.0]
		];
		
		NSArray *startPoints = @[@0.1f, @0.5909f, @0.8363f, @0.9181f, @1.f
		];
		
		QHeatGradient *grad = [[QHeatGradient alloc] initWithColor:styleColors andWithStartPoints:startPoints];
		
		self.heatOverlay.enable3D = YES;
		self.heatOverlay.gradient = grad;
		
		[self.heatOverlay setNeedsDisplay];
		
	}
}

// 12 配色4
- (void)changeColorStyleFour
{
	self.mapView.mapType = QMapTypeDark;
	self.mapView.overlooking = 40;
	
	if (self.heatOverlay)
	{
		NSArray *styleColors =  @[
			[UIColor colorWithRed:0x4F / 255.0 green:0x17 / 255.0 blue:0x40 / 255.0 alpha:1.0],
			[UIColor colorWithRed:0x90 / 255.0 green:0x09 / 255.0 blue:0x3B / 255.0 alpha:1.0],
			[UIColor colorWithRed:0xCB / 255.0 green:0x01 / 255.0 blue:0x34 / 255.0 alpha:1.0],
			[UIColor colorWithRed:0xE7 / 255.0 green:0x5D / 255.0 blue:0x18 / 255.0 alpha:1.0],
			[UIColor colorWithRed:0xFF / 255.0 green:0xAA / 255.0 blue:0x00 / 255.0 alpha:1.0]
		];
		
		NSArray *startPoints = @[@0.1f, @0.5959f, @0.8163f, @0.9265f, @1.f
		];
		
		QHeatGradient *grad = [[QHeatGradient alloc] initWithColor:styleColors andWithStartPoints:startPoints];
		
		self.heatOverlay.enable3D = YES;
		self.heatOverlay.gradient = grad;
		
		[self.heatOverlay setNeedsDisplay];
		
	}
}

- (NSString *)testTitle
{
	return @"添加";
}


@end
