//
//  SnapshotViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2019/7/18.
//  Copyright © 2019 tencent. All rights reserved.
//

#import "SnapshotViewController.h"

@interface SnapshotViewController ()
@property (nonatomic, strong) UIImageView *shotView;


@end

@implementation SnapshotViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view
    
    self.mapView.centerCoordinate = CLLocationCoordinate2DMake(40.040432,116.273498);
    self.mapView.zoomLevel = 17;
    [self.mapView setIndoorEnabled:NO];
    //设置截图view
    self.shotView = [[UIImageView alloc] initWithFrame:CGRectMake(10, 400, 230, 150)];
    [self.view addSubview:self.shotView];
    self.shotView.layer.borderColor = [UIColor redColor].CGColor;
    self.shotView.layer.borderWidth = 2;
    self.shotView.backgroundColor = [UIColor lightGrayColor];
    UILabel *title = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 230, 50)];
    title.backgroundColor = [UIColor whiteColor];
    title.text = @"[位置]腾讯北京总部大楼";
    [self.shotView addSubview:title];
    
    [self testsnap];
}

- (void)testsnap
{
    __weak __typeof(self) ws = self;
    
	CGRect snapShotRect = CGRectMake(self.mapView.bounds.size.width * 0.4, self.mapView.bounds.size.height * 0.4, 230, 150);
	
    //异步截图
	[self.mapView takeSnapshotInRect:snapShotRect timeout:2 afterScreenUpdates:YES completion:^(UIImage *resultImage) {
		ws.shotView.image = resultImage;
	}];
}


@end
