//
//  DistanceMatrixSearchViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/19.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "DistanceMatrixSearchViewController.h"
#import <QMapKit/QMSSearchKit.h>

@interface DistanceMatrixSearchViewController () <QMSSearchDelegate>

@property (nonatomic, strong) QMSSearcher *mySearcher;

@end

@implementation DistanceMatrixSearchViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
	self.mySearcher = [[QMSSearcher alloc] initWithDelegate:self];
	QMSDistanceMatrixSearchOption *dmOpt = [[QMSDistanceMatrixSearchOption alloc] init];
	dmOpt.mode 	= @"driving";
	dmOpt.from 	= @"39.829647,117.422462,-1,0,-1,0,1639108623|39.830553,116.422924,-1,0,-1,0,1639108628|39.931261,116.423289,-1,0,-1,0,1639108633";
	dmOpt.to	= @"39.071510,117.190091;40.007632,116.389160;39.108951,117.279396";
	
	[self.mySearcher searchWithDistanceMatrixSearchSearchOption:dmOpt];
}

#pragma mark -- Search Delegate

- (void)searchWithSearchOption:(QMSSearchOption *)searchOption didFailWithError:(NSError *)error
{
	NSLog(@"error:%@", error);
}

- (void)searchWithDistanceMatrixSearchOption:(QMSDistanceMatrixSearchOption *)distanceMatrixSearchOption didRecevieResult:(QMSDistanceMatrixSearchResult *)distanceMatrixSearchResult
{
	for (QMSDistanceMatrixElement *element in distanceMatrixSearchResult.rows)
	{
		for (QMSDistanceMatrixElementUnit *unit in element.elements)
		{
			NSLog(@"Distance unit info distance:%f, duration:%f", unit.distance, unit.distance);
		}
	}
}

@end
