//
//  TileOverlayViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2019/7/18.
//  Copyright © 2019 tencent. All rights reserved.
//

#import "TileOverlayViewController.h"

#define SatelliteTemplate @"https://www.google.cn/maps/vt?lyrs=s@847&gl=cn&x={x}&y={y}&z={z}"

@interface TileOverlayViewController ()

@property (nonatomic, strong) QTileOverlay *tileOverlaySatellite;

@end

@implementation TileOverlayViewController

-(NSString *)testTitle
{
    return @"添加/移除";
}

- (void)handleTestAction
{
	
    QTileOverlayView *tileOverlayView = (QTileOverlayView *)[self.mapView viewForOverlay:self.tileOverlaySatellite];
	if (tileOverlayView)
	{
		[self.mapView removeOverlay:self.tileOverlaySatellite];
	}
    else
	{
		[self.mapView addOverlay:self.tileOverlaySatellite];
	}
}

- (void)setUpTileOverlay
{
    self.tileOverlaySatellite = [[QTileOverlay alloc] initWithURLTemplate:SatelliteTemplate];
    //如使用默认缓存则需在添加overlay前设置存在文件夹名
    self.tileOverlaySatellite.tileCacheDir = @"satelite";
    
    [self.mapView addOverlay:self.tileOverlaySatellite];
}

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
    //生成瓦片图的render
    if ([overlay isKindOfClass:[QTileOverlay class]]) {
        QTileOverlayView *render = [[QTileOverlayView alloc] initWithTileOverlay:overlay];
        return render;
    }
    
    return nil;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpTileOverlay];
    
}

@end
