//  EraseLineViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2019/7/18.
//  Copyright © 2019 tencent. All rights reserved.
//

#import "EraseLineViewController.h"

@interface EraseLineViewController ()

@property (nonatomic, strong) QPolyline *polyline;

@end

#pragma mark -- EraseLine Demo
@implementation EraseLineViewController


//擦除路线
-(void)handleEraseLine
{
    QTexturePolylineView *polylineView = (QTexturePolylineView *)[self.mapView viewForOverlay:self.polyline];
	polylineView.eraseColor = [UIColor redColor];
	
	// toColor为YES时，线会被擦除成透明色
    [polylineView eraseFromStartToCurrentPoint:CLLocationCoordinate2DMake(39.846874, 116.494518) searchFrom:2 toColor:NO];
}

//置灰路线
- (void)handleTestAction
{
    QTexturePolylineView *polylineView = (QTexturePolylineView *)[self.mapView viewForOverlay:self.polyline];
    
    [polylineView eraseFromStartToCurrentPoint:CLLocationCoordinate2DMake(39.948517, 116.484256) searchFrom:1 toColor:NO];
}

- (void)restLine
{
	[self.mapView removeOverlay:self.polyline];
	[self.mapView addOverlay:self.polyline];
}

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
    if ([overlay isKindOfClass:[QPolyline class]]) {
        QTexturePolylineView *polylineRender = [[QTexturePolylineView alloc] initWithPolyline:overlay];
        polylineRender.lineWidth = 5;
        polylineRender.drawType = QTextureLineDrawType_ColorLine;
        polylineRender.drawSymbol = NO;
        polylineRender.strokeColor = [UIColor greenColor];
        
        return polylineRender;
        
    }
    
    return  nil;
}

//设置路径
-(void)setupPath
{
    const int COUNT = 4;
    CLLocationCoordinate2D polylineCoords[COUNT];
    polylineCoords[0].latitude = 39.9442;
    polylineCoords[0].longitude = 116.608821;
    
    polylineCoords[1].latitude = 39.948517;
    polylineCoords[1].longitude = 116.484256;
    
    polylineCoords[2].latitude = 39.846874;
    polylineCoords[2].longitude = 116.494518;
    
    polylineCoords[3].latitude = 39.833368;
    polylineCoords[3].longitude = 116.610921;
    
    self.polyline = [[QPolyline alloc] initWithCoordinates:polylineCoords count:COUNT];
    
    [self.mapView addOverlay:self.polyline];
    
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    UIBarButtonItem *testItem = [[UIBarButtonItem alloc] initWithTitle:@"擦除"
                                                                 style:UIBarButtonItemStylePlain
                                                                target:self
                                                                action:@selector(handleEraseLine)];
    UIBarButtonItem *testItem1 = [[UIBarButtonItem alloc] initWithTitle:@"置灰"
                                                                  style:UIBarButtonItemStylePlain
                                                                 target:self
                                                                 action:@selector(handleTestAction)];
	UIBarButtonItem *testItem2 = [[UIBarButtonItem alloc] initWithTitle:@"重置"
																  style:UIBarButtonItemStylePlain
																 target:self
																 action:@selector(restLine)];
    
    self.navigationItem.rightBarButtonItems = @[testItem1, testItem, testItem2];
    
	[self setupPath];
	
    [self.mapView setVisibleMapRect:self.polyline.boundingMapRect edgePadding:UIEdgeInsetsMake(20, 10, 10, 40) animated:YES];
    
    
}

@end
