//
//  DashPolygonViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/16.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "DashPolygonViewController.h"

typedef NS_ENUM(NSUInteger, DashPolygonType)
{
	// 默认方块虚线
	TypeDefaultDash,
	// 原点虚线
	TypeDotDash,
	// 自定义图片虚线
	TypeCustomImageDash,
};

@interface DashPolygonViewController ()

@property (nonatomic, strong) NSMutableArray<id <QOverlay>> *overlays;

@end

@implementation DashPolygonViewController

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QPolygon class]])
	{
		QPolygonView *polygonView = [[QPolygonView alloc] initWithPolygon:overlay];
		polygonView.strokeColor = [UIColor colorWithRed:70/255.0 green:119/255.0 blue:223/255.0 alpha:.8];
		polygonView.fillColor   = [[UIColor grayColor] colorWithAlphaComponent:0.2];
		
		QPolygon *polygon = (QPolygon *)overlay;
		DashPolygonType type = [polygon.userData intValue];
		if (type == TypeDefaultDash) {
			// 虚线线
			polygonView.lineType = QOverlayStrokeType_Dash;
			polygonView.lineDashPattern = @[@10, @5];
			polygonView.lineWidth   = 4;
		} else if (type == TypeDotDash) {
			// 原点虚线
			polygonView.lineType = QOverlayStrokeType_Dot;
			polygonView.textureGap = 10;
			polygonView.lineWidth   = 6;
		} else if (type == TypeCustomImageDash){
			polygonView.lineType = QOverlayStrokeType_Dot;
			polygonView.styleTextureImage = [UIImage imageNamed:@"ball.png"];
			polygonView.lineWidth   = 20;
			polygonView.textureGap = 10;
		}
		
		return polygonView;
	}
	
	return nil;
}

- (void)setupOverlays
{
	self.overlays = [NSMutableArray array];
	
	/* Polygon1. */
	CLLocationCoordinate2D coords[6];
	coords[0].latitude = 40.041533;
	coords[0].longitude = 116.271481;
	
	coords[1].latitude = 40.041845;
	coords[1].longitude = 116.274464;
	
	coords[2].latitude = 40.038954;
	coords[2].longitude = 116.27515;
	
	coords[3].latitude = 40.038568;
	coords[3].longitude = 116.272146;
	
	QPolygon *polygon = [QPolygon polygonWithCoordinates:coords count:4];
	polygon.userData = @(TypeDefaultDash);
	[self.overlays addObject:polygon];
	
	/* Polygon1. */
	CLLocationCoordinate2D coords1[6];
	coords1[0].latitude = 40.041895;
	coords1[0].longitude = 116.274668;
	
	coords1[1].latitude = 40.042297;
	coords1[1].longitude = 116.277715;
	
	coords1[2].latitude = 40.041032;
	coords1[2].longitude = 116.277983;
	
	coords1[3].latitude = 40.04058;
	coords1[3].longitude = 116.275032;
	
	QPolygon *polygon1 = [QPolygon polygonWithCoordinates:coords1 count:4];
	polygon1.userData = @(TypeDotDash);
	[self.overlays addObject:polygon1];
	
	/* Polygon2. */
	CLLocationCoordinate2D coordinates[4];
	coordinates[0].latitude = 40.040498;
	coordinates[0].longitude = 116.275011;
	
	coordinates[1].latitude = 40.040966;
	coordinates[1].longitude = 116.278037;
	
	coordinates[2].latitude = 40.039537;
	coordinates[2].longitude = 116.278337;
	
	coordinates[3].latitude = 40.038987;
	coordinates[3].longitude = 116.275311;
	QPolygon *polygon2 = [QPolygon polygonWithCoordinates:coordinates count:4];
	polygon2.userData = @(TypeCustomImageDash);
	[self.overlays addObject:polygon2];
}

- (void)viewDidLoad {
	[super viewDidLoad];
	
	[self setupOverlays];
	[self.mapView addOverlays:self.overlays];
	[self.mapView setCenterCoordinate:CLLocationCoordinate2DMake(40.040531,116.274936)];
	[self.mapView setZoomLevel:16];
}

@end
