//
//  ArcPolylineViewController.m
//  QMapKitDemo
//
//  Created by v_hefang on 2020/12/23.
//  Copyright © 2020 tencent. All rights reserved.
//

#import "ArcPolylineViewController.h"

@interface ArcPolylineViewController ()

@end

@implementation ArcPolylineViewController

- (void)setupArc {
    // 添加Annotation
    CLLocationCoordinate2D startPoint  =    CLLocationCoordinate2DMake(39.89491,116.322056);
    CLLocationCoordinate2D endPoint    =    CLLocationCoordinate2DMake(22.547,114.085947);
    CLLocationCoordinate2D passedPoint =    CLLocationCoordinate2DMake(32.059352,118.796623);
    
    QPointAnnotation *startAnnotation = [[QPointAnnotation alloc] init];
    startAnnotation.coordinate = startPoint;
    
    QPointAnnotation *endAnnotation = [[QPointAnnotation alloc] init];
    endAnnotation.coordinate = endPoint;
    
    QPointAnnotation *passedAnnotation = [[QPointAnnotation alloc] init];
    passedAnnotation.coordinate = passedPoint;
    [self.mapView addAnnotations:@[startAnnotation, passedAnnotation, endAnnotation]];
    
    
    // 添加弧线
    QArc *arc1 = [[QArc alloc] initWithStartPoint:startPoint
                                         endPoint:endPoint
                                      passedPoint:passedPoint];
    [self.mapView addOverlay:arc1];
    
    
    // 调整视野
    QMapRect newMapRect = [self.mapView mapRectThatFits:arc1.boundingMapRect edgePadding:UIEdgeInsetsMake(50, 0, 50, 0)];
    [self.mapView setVisibleMapRect:newMapRect animated:YES];
}

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay {
    if ([overlay isKindOfClass:[QArc class]]) {
        QArcView *arcView = [[QArcView alloc] initWithArc:overlay];
        arcView.lineWidth = 3;
        arcView.strokeColor = [UIColor colorWithRed:70/255.0 green:119/255.0 blue:223/255.0 alpha:.8];
        
        return arcView;
    }
    
    return nil;;
}

- (QAnnotationView *)mapView:(QMapView *)mapView viewForAnnotation:(id<QAnnotation>)annotation {
    static NSString *reuse = @"annotation";
    QPinAnnotationView *annotationView = [mapView dequeueReusableAnnotationViewWithIdentifier:annotation];
    if (annotationView == nil) {
        annotationView = [[QPinAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:reuse];
    }
    
    return annotationView;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupArc];
}

@end
